/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.swiftlx.dc.handle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.ebg.aqap.banks.swiftlx.dc.handle.SWIFTMessage;
import kd.ebg.aqap.proxy.swift.model.SwiftApplicationHeaderBlock;
import kd.ebg.aqap.proxy.swift.model.SwiftBasicHeaderBlock;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.egf.common.log.EBGLogger;

public class HandleUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HandleUtils.class);
    public static final DateTimeFormatter SWIFT_DATA_FORMAT = DateTimeFormatter.ofPattern("yyMMdd");

    public static SWIFTMessage readFileContentAsString(File file) throws IOException {
        StringBuilder buffer = new StringBuilder();
        ArrayList<SwiftTextBlock> list = new ArrayList<SwiftTextBlock>();
        SwiftBasicHeaderBlock block1 = new SwiftBasicHeaderBlock();
        SwiftApplicationHeaderBlock block2 = new SwiftApplicationHeaderBlock();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("{1:") || line.contains("{2:") || line.contains("{3:") || line.contains("{4:")) {
                        if (line.contains("{1:")) {
                            block1.setUnParserText(HandleUtils.subBlock(line, "{1:"));
                            block1.parserText();
                        }
                        if (!line.contains("{2:")) continue;
                        block2.setUnParserText(HandleUtils.subBlock(line, "{2:"));
                        block2.parserText();
                        continue;
                    }
                    if ("-".equals(line) || line.startsWith("-}")) {
                        String content = HandleUtils.packToSwiftTextBlock(buffer.toString().trim());
                        SwiftTextBlock swiftTextBlock = new SwiftTextBlock();
                        swiftTextBlock.setUnParserText(content);
                        swiftTextBlock.parserText();
                        list.add(swiftTextBlock);
                        buffer = new StringBuilder();
                        continue;
                    }
                    buffer.append(line).append("\n");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6" + file.getName() + "\u53d1\u751f\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        return new SWIFTMessage(block1, block2, list);
    }

    private static String packToSwiftTextBlock(String content) {
        return "{4:\n" + content + "\n-}";
    }

    public static BigDecimal toBigDecimal(String s) {
        try {
            return new BigDecimal(s);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static String subBlock(String content, String blockPrefix) {
        int index = content.indexOf(blockPrefix);
        int indexCloseBrace = content.indexOf("}", index);
        if (indexCloseBrace == -1) {
            return content + "}";
        }
        return content.substring(index, indexCloseBrace + 1);
    }
}

