/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.swiftlx.dc.handle;

import com.google.common.collect.Lists;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.swiftlx.dc.handle.Filter;
import kd.ebg.aqap.banks.swiftlx.dc.handle.HandleUtils;
import kd.ebg.aqap.banks.swiftlx.dc.handle.SWIFTMessage;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT940Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.swift.model.SwiftApplicationHeaderBlock;
import kd.ebg.aqap.proxy.swift.model.SwiftBasicHeaderBlock;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.aqap.proxy.swift.model.Tag;
import kd.ebg.aqap.proxy.swift.model.field.Field25;
import kd.ebg.aqap.proxy.swift.model.field.Field60F;
import kd.ebg.aqap.proxy.swift.model.field.Field60M;
import kd.ebg.aqap.proxy.swift.model.field.Field61;
import kd.ebg.aqap.proxy.swift.model.field.Field62F;
import kd.ebg.aqap.proxy.swift.model.field.Field62M;
import kd.ebg.aqap.proxy.swift.model.field.Field64;
import kd.ebg.aqap.proxy.swift.model.field.Field86;
import kd.ebg.aqap.proxy.swift.utils.SwiftTagsUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MT940_Handler
extends AbstractMT940Handler {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(MT940_Handler.class);

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return Filter.mt940(fileName);
    }

    public void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        String name = file.getName();
        if (!this.isNeedToProcessFile(name)) {
            return;
        }
        try {
            SWIFTMessage swiftMessage = HandleUtils.readFileContentAsString(file);
            List<SwiftTextBlock> list = swiftMessage.getSwiftTextBlockList();
            SwiftBasicHeaderBlock block1 = swiftMessage.getBlock1();
            SwiftApplicationHeaderBlock block2 = swiftMessage.getBlock2();
            this.logger.info("{1\uff1a-> {}", (Object)block1.toString());
            this.logger.info("{2\uff1a-> {}", (Object)block2.toString());
            for (SwiftTextBlock aList : list) {
                this.logger.info(aList.getUnParserText());
                this.parseHistoryDetails(block1, block2, aList, name, detailInfoList, payInfoList, balanceInfoList);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u524d\u65e5\u4ea4\u6613\u660e\u7ec6\u62a5\u544a[%1$s]\u51fa\u9519:%2$s", (String)"UOBSG_DC_MT940_Handler_2", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]), name, e.getMessage()), (Throwable)e);
        }
    }

    private void parseHistoryDetails(SwiftBasicHeaderBlock block1, SwiftApplicationHeaderBlock block2, SwiftTextBlock swiftTextBlock, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        BigDecimal openingBalance;
        String date62F;
        Field25 field25 = new Field25(swiftTextBlock.getTagValue("25"));
        Field60F field60F = new Field60F(swiftTextBlock.getTagValue("60F"));
        Field60M field60M = new Field60M(swiftTextBlock.getTagValue("60M"));
        Field62F field62F = new Field62F(swiftTextBlock.getTagValue("62F"));
        Field62M field62M = new Field62M(swiftTextBlock.getTagValue("62M"));
        String acntNumber = field25.getComponent1();
        String currency = field60F.getComponent3();
        if (StringUtils.isEmpty((String)currency)) {
            currency = field60M.getComponent3();
        }
        if (StringUtils.isEmpty((String)(date62F = field62F.getComponent2()))) {
            date62F = field62M.getComponent2();
        }
        if (StringUtils.isEmpty((String)date62F)) {
            this.logger.info("\u6570\u636e\u4e0d\u89c4\u8303\uff0c\u7f3a\u593162F\u621662M\uff0c\u4e0d\u89e3\u6790\u3002");
            return;
        }
        LocalDate date = LocalDate.parse(date62F, HandleUtils.SWIFT_DATA_FORMAT);
        this.parse61To86Tags(block1, block2, swiftTextBlock, acntNumber, currency, fileName, detailInfoList, payInfoList, date);
        Field64 field64 = new Field64(swiftTextBlock.getTagValue("64"));
        try {
            openingBalance = field60F.getComponent4AsBigDecimal();
            String balSign = field60F.getComponent1AsString();
            if (null == openingBalance) {
                openingBalance = field60M.getComponent4AsBigDecimal();
                balSign = field60M.getComponent1AsString();
            }
            if ("D".equalsIgnoreCase(balSign)) {
                openingBalance = openingBalance.multiply(new BigDecimal("-1"));
            }
        }
        catch (Exception e) {
            this.logger.info(ResManager.loadKDString((String)"\u83b7\u53d6\u5386\u53f2\u660e\u7ec6Opening Balance \u4f59\u989d\u5931\u8d25", (String)"UOBSG_DC_MT940_Handler_1", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]), (Object)e);
            throw e;
        }
        this.calcBalance(detailInfoList, openingBalance, acntNumber);
        BigDecimal closingBalance = field62F.getComponent4AsBigDecimal();
        if (closingBalance == null) {
            return;
        }
        BigDecimal closingAvailableBalance = field64.getComponent4AsBigDecimal();
        OverseaBalance balanceInfo = new OverseaBalance();
        balanceInfo.setNumber(acntNumber);
        balanceInfo.setCurrency(currency);
        balanceInfo.setCurrentBalance(closingBalance);
        balanceInfo.setAvailableBalance(closingAvailableBalance);
        balanceInfo.setLastDayBalance(openingBalance);
        balanceInfo.setBalanceDate(date.atTime(0, 0, 0));
        balanceInfo.setUpdateSource(fileName);
        balanceInfo.setBankVersion(this.context.getBankVersionID());
        balanceInfoList.add(balanceInfo);
    }

    private void parse61To86Tags(SwiftBasicHeaderBlock block1, SwiftApplicationHeaderBlock block2, SwiftTextBlock swiftTextBlock, String acntNumber, String currency, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, LocalDate transTime) {
        List tags = swiftTextBlock.getTags();
        int[] tag61Index = SwiftTagsUtils.getTagsIndex((List)tags, (String)"61");
        if (0 == tag61Index.length) {
            return;
        }
        for (int aTag61Index : tag61Index) {
            Field61 field61 = new Field61(((Tag)tags.get(aTag61Index)).getTagValue());
            OverseaDetail detail = new OverseaDetail();
            detail.setNumber(acntNumber);
            detail.setPayBankName(block1.getLogicalTerminal());
            detail.setPayBankVersion(this.context.getBankVersionID());
            detail.setBenefitBankName(block2.getReceiverBIC());
            detail.setExtField4(block2.getUniqueReference());
            detail.setDetailFileName(fileName);
            detail.setCreatetime(LocalDateTime.now());
            detail.setCustomId(EBContext.getContext().getCustomID());
            detail.setTxDate(transTime);
            detail.setCurrency(currency);
            BigDecimal amount = field61.getComponent5AsBigDecimal();
            String creditOrDebit = field61.getComponent3();
            if ("C".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else if ("D".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount);
            } else {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b,\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411.", (String)"UOBSG_DC_MT940_Handler_3", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]), creditOrDebit));
            }
            String custRef = field61.getComponent7() == null ? "" : field61.getComponent7().trim().toLowerCase();
            detail.setExtField1(custRef);
            String transType = field61.getComponent6();
            detail.setTransType(transType);
            String explanation = String.join((CharSequence)" ", Lists.newArrayList((Object[])new String[]{custRef, field61.getComponent8() == null ? "" : field61.getComponent8()}));
            Tag tag86 = SwiftTagsUtils.getTagBetween((List)tags, (String)"86", (int)aTag61Index, (int)(aTag61Index + 1));
            StringBuilder ex = new StringBuilder(explanation);
            ex.append("\n");
            if (null != tag86) {
                Field86 field86 = new Field86(tag86.getTagValue());
                List field86List = field86.getComponents();
                for (String fie : field86List) {
                    if (StringUtils.isEmpty((String)fie) || "null".equals(fie)) continue;
                    ex.append(fie);
                }
            }
            detail.setExplanation(ex.toString().replace("//", "").trim());
            detail.setDetailType("940");
            detailInfoList.add(detail);
        }
    }

    private void calcBalance(List<OverseaDetail> detailList, BigDecimal currentValue, String accNo) {
        HashSet<LocalDate> set = new HashSet<LocalDate>(16);
        for (OverseaDetail info : detailList) {
            set.add(info.getTxDate());
        }
        for (LocalDate date : set) {
            for (OverseaDetail info : detailList) {
                if (!info.getTxDate().equals(date) || !info.getNumber().equals(accNo)) continue;
                BigDecimal txAmt = info.getTxAmt();
                currentValue = "CREDIT".equals(info.getCordFlag()) ? currentValue.add(txAmt) : currentValue.subtract(txAmt);
                info.setBalance(currentValue);
            }
        }
    }
}

