/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.swiftlx.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.repository.OverseaBalanceRepository;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance,
IHisBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        BankAcnt.Proxy proxy = acnt.getProxyByCurrency(request.getBankCurrency());
        String accNo = acnt.getAccNo();
        if (proxy != null) {
            logger.info("\u4ee3\u7406\u8d26\u53f7{}\uff0c\u5e01\u522b{}\u3002", new Object[]{proxy.getInquiryaccount(), proxy.getCurrency()});
            accNo = proxy.getInquiryaccount();
        }
        EBContext context = EBContext.getContext();
        OverseaBalanceRepository overseaBalanceRepository = (OverseaBalanceRepository)SpringContextUtil.getBean(OverseaBalanceRepository.class);
        OverseaBalance lastestBalance = overseaBalanceRepository.getLastestBalance(accNo, context.getCustomID(), context.getBankVersionID(), request.getBankCurrency());
        if (lastestBalance == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u786e\u8ba4\u662f\u5426\u63a8\u9001\u4e86\u5bf9\u5e94\u7684\u6587\u4ef6\u6570\u636e\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-swiftlx-dc", (Object[])new Object[0]));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setCurrentBalance(lastestBalance.getCurrentBalance());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        if (lastestBalance.getAvailableBalance() != null && lastestBalance.getAvailableBalance().compareTo(BigDecimal.ZERO) != 0) {
            balanceInfo.setAvailableBalance(lastestBalance.getAvailableBalance());
        }
        balanceInfo.setBankAcnt(acnt);
        balanceInfo.setLastDayAvlBalance(lastestBalance.getLastDayBalance());
        balanceInfo.setBalanceDateTime(lastestBalance.getBalanceDate());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public EBBankBalanceResponse hisBalance(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        BankAcnt.Proxy proxy = acnt.getProxyByCurrency(request.getBankCurrency());
        String accNo = acnt.getAccNo();
        if (proxy != null) {
            logger.info("\u4ee3\u7406\u8d26\u53f7{}\uff0c\u5e01\u522b{}\u3002", new Object[]{proxy.getInquiryaccount(), proxy.getCurrency()});
            accNo = proxy.getInquiryaccount();
        }
        EBContext context = EBContext.getContext();
        OverseaBalanceRepository overseaBalanceRepository = (OverseaBalanceRepository)SpringContextUtil.getBean(OverseaBalanceRepository.class);
        OverseaBalance balance = overseaBalanceRepository.getBalanceByDate(accNo, context.getCustomID(), context.getBankVersionID(), request.getBankCurrency(), request.getStartDate());
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(acnt);
        if (balance == null) {
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        }
        balanceInfo.setCurrentBalance(balance.getCurrentBalance());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBalanceDateTime(balance.getBalanceDate());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public LocalDate limitDate() {
        return null;
    }

    public int queryDays() {
        return 1;
    }

    public boolean async() {
        return false;
    }
}

