/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.swiftlx.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.repository.OverseaDetailRepository;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        BankAcnt.Proxy proxy = acnt.getProxyByCurrency(request.getBankCurrency());
        String accNo = acnt.getAccNo();
        if (proxy != null) {
            logger.info("\u4ee3\u7406\u8d26\u53f7{}\uff0c\u5e01\u522b{}\u3002", new Object[]{proxy.getInquiryaccount(), proxy.getCurrency()});
            accNo = proxy.getInquiryaccount();
        }
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        EBContext context = EBContext.getContext();
        OverseaDetailRepository bean = (OverseaDetailRepository)SpringContextUtil.getBean(OverseaDetailRepository.class);
        List overseaDetails = bean.queryDetail(context.getCustomID(), startDate, endDate, accNo, request.getBankCurrency());
        List<DetailInfo> detailInfos = this.parseDetail(request, overseaDetails);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> parseDetail(BankDetailRequest request, List<OverseaDetail> lists) {
        BankAcnt acnt = request.getAcnt();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        for (OverseaDetail overseaDetail : lists) {
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acnt.getAccNo());
            detail.setAccName(acnt.getAccName());
            detail.setBankName(overseaDetail.getPayBankName());
            detail.setTransDate(overseaDetail.getTxDate());
            detail.setTransTime(overseaDetail.getTxDate().atTime(0, 0, 0));
            String cdFlag = overseaDetail.getCordFlag();
            BigDecimal Amount = overseaDetail.getTxAmt();
            if ("CREDIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(Amount);
                detail.setDebitAmount(BigDecimalHelper.ZERO);
            } else if ("DEBIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(BigDecimalHelper.ZERO);
                detail.setDebitAmount(Amount);
            }
            String txCurrency = overseaDetail.getCurrency();
            detail.setCurrency(txCurrency);
            BigDecimal balance = overseaDetail.getBalance();
            if (balance != null) {
                detail.setBalance(balance);
            }
            String oppAcntNo = overseaDetail.getBenefitAccNo();
            String oppAcntName = overseaDetail.getBenefitAccName();
            String oppBankName = overseaDetail.getBenefitBankName();
            detail.setOppAccNo(oppAcntNo);
            detail.setOppAccName(oppAcntName);
            detail.setOppBankName(oppBankName);
            String explanination = overseaDetail.getExplanation();
            detail.setExplanation(explanination);
            logger.info("\u660e\u7ec6\u7684\u94f6\u884c\u6279\u6b21\u53f7\u662f{}", (Object)overseaDetail.getExtField1());
            detailList.add(detail);
        }
        return detailList;
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "detail";
    }

    public String getBizDesc() {
        return null;
    }
}

