/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjws.opa.services.payment;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjws.opa.utils.AntUtils;
import kd.ebg.aqap.banks.zjws.opa.utils.ResultInfo;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element body = AntUtils.createBody();
        JDomUtils.addChild((Element)body, (String)"partner", (String)RequestContextUtils.getBankParameterValue((String)"partner_id"));
        JDomUtils.addChild((Element)body, (String)"bizNo", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)body, (String)"cardNo", (String)paymentInfo.getAccNo());
        return AntUtils.execute(body, this.getBizCode(), Lists.newArrayList((Object[])new String[]{"bizNo", "cardNo"}));
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        Element response = AntUtils.getResponse(s);
        Element body = response.getChild("body");
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        ResultInfo resultInfo = AntUtils.getResultInfo(body, false);
        if (!resultInfo.isSuccess()) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)resultInfo.getStatusAndCode(), (String)resultInfo.getResultMsg());
            return new EBBankPayResponse(paymentInfos);
        }
        String status = body.getChildTextTrim("status");
        String errorDesc = body.getChildTextTrim("errorDesc");
        if ("success".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)"", (String)errorDesc);
        } else if ("failure".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)"", (String)errorDesc);
        } else if ("inprocess".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)errorDesc);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)errorDesc);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ant.ebank.transfer.singlepay.query";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u4e1a\u52a1\u72b6\u6001\u67e5\u8be2", (String)"", (String)"ebg-aqap-banks-zjws-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        AntUtils.setURI(factory);
    }
}

