/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjws.opa.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjws.opa.utils.AntUtils;
import kd.ebg.aqap.banks.zjws.opa.utils.Dao;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Crypto {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Crypto.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String signBizParams(String oriContent) {
        logger.info("\u5f85\u7b7e\u540d\u7684\u4e1a\u52a1\u53c2\u6570\uff1a{}", (Object)oriContent);
        CertInfo twPrivateCert = Dao.getTWPrivateCert();
        String fileContent = twPrivateCert.getFileContent();
        String certPassword = twPrivateCert.getCertPassword();
        String alias = RequestContextUtils.getBankParameterValue((String)"alias");
        try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.decodeBase64((String)fileContent));){
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            keyStore.load(is, certPassword.toCharArray());
            if (StringUtils.isEmpty((String)alias)) {
                ArrayList<String> aliasesList = Collections.list(keyStore.aliases());
                alias = aliasesList.get(0);
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, certPassword.toCharArray());
            String hashAlg = AntUtils.getHashAlg() + "withRSA";
            ContentSigner contentSigner = new JcaContentSignerBuilder(hashAlg).build(privateKey);
            DigestCalculatorProvider digestCalculator = new JcaDigestCalculatorProviderBuilder().build();
            JcaSignerInfoGeneratorBuilder signerInfoBuilder = new JcaSignerInfoGeneratorBuilder(digestCalculator);
            signerInfoBuilder.setDirectSignature(true);
            SignerInfoGenerator signerInfo = signerInfoBuilder.build(contentSigner, new X509CertificateHolder(cert.getEncoded()));
            ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>(1);
            certificateList.add(cert);
            JcaCertStore certs = new JcaCertStore(certificateList);
            CMSSignedDataGenerator cmsGenerator = new CMSSignedDataGenerator();
            cmsGenerator.addSignerInfoGenerator(signerInfo);
            cmsGenerator.addCertificates((Store)certs);
            CMSProcessableByteArray msg = new CMSProcessableByteArray(oriContent.getBytes(StandardCharsets.UTF_8));
            CMSSignedData cmsSignedData = cmsGenerator.generate((CMSTypedData)msg, false);
            byte[] signedData = cmsSignedData.getEncoded("DER");
            String string = Base64.encodeBase64String((byte[])signedData);
            return string;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException | CMSException | OperatorCreationException e) {
            logger.info("\u7b7e\u540d\u5f02\u5e38{}", new Object[]{e.getClass().getName(), e});
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        catch (Exception e) {
            logger.info("\u7b7e\u540d\u5176\u4ed6\u5f02\u5e38{}", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static void addSignature(Element root, String toEncryptContent) {
        String signatureValue;
        String digestValue;
        PrivateKey privateKey;
        CertInfo userPrivate = Dao.getUserPrivate();
        if (Objects.isNull(userPrivate)) {
            return;
        }
        logger.info("\u5f85\u7b7e\u540d\u7684\u6574\u4f53\u62a5\u6587\uff1a{}", (Object)toEncryptContent);
        String privateKeyBase64 = new String(Base64.decodeBase64((String)userPrivate.getFileContent()), StandardCharsets.UTF_8);
        StringReader reader = new StringReader(privateKeyBase64);
        PEMParser pemParser = new PEMParser((Reader)reader);
        try {
            PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemParser.readObject();
            privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u79c1\u94a5\u5931\u8d25", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u7528\u6237\u79c1\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bc6\u94a5\u6216\u6570\u636e\u683c\u5f0f\u3002", (String)"Crypto_1", (String)"ebg-aqap-banks-zjws-opa", (Object[])new Object[0]));
        }
        try {
            byte[] encryptContentBytes = toEncryptContent.getBytes(StandardCharsets.UTF_8);
            Signature signer = Signature.getInstance("SHA256withRSA");
            MessageDigest digest = MessageDigest.getInstance(AntUtils.getHashAlg());
            digestValue = Base64.encodeBase64String((byte[])digest.digest(encryptContentBytes));
            signer.initSign(privateKey);
            signer.update(encryptContentBytes);
            signatureValue = Base64.encodeBase64String((byte[])signer.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            logger.error("\u7b7e\u540d\u5f02\u5e38" + e.getClass().getName(), (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5f02\u5e38\u3002", (String)"Crypto_2", (String)"ebg-aqap-banks-zjws-opa", (Object[])new Object[0]));
        }
        Element signature = JDomUtils.createRoot((String)"Signature");
        Namespace ns = Namespace.getNamespace((String)"", (String)"http://www.w3.org/2000/09/xmldsig#");
        signature.setNamespace(ns);
        Element signedInfo = JDomUtils.addChild((Element)signature, (String)"SignedInfo").setNamespace(ns);
        Element canonicalizationMethod = JDomUtils.addChild((Element)signedInfo, (String)"CanonicalizationMethod").setNamespace(ns);
        canonicalizationMethod.setAttribute("Algorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        Element signatureMethod = JDomUtils.addChild((Element)signedInfo, (String)"SignatureMethod").setNamespace(ns);
        signatureMethod.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Element reference = JDomUtils.addChild((Element)signedInfo, (String)"Reference").setNamespace(ns);
        reference.setAttribute("URI", "");
        Element transforms = JDomUtils.addChild((Element)reference, (String)"Transforms").setNamespace(ns);
        Element transform = JDomUtils.addChild((Element)transforms, (String)"Transform").setNamespace(ns);
        transform.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        Element digestMethod = JDomUtils.addChild((Element)reference, (String)"DigestMethod").setNamespace(ns);
        digestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        JDomUtils.addChild((Element)reference, (String)"DigestValue", (String)digestValue).setNamespace(ns);
        JDomUtils.addChild((Element)signature, (String)"SignatureValue", (String)signatureValue).setNamespace(ns);
        JDomUtils.addChild((Element)root, (Element)signature);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

