/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjhxb.dc.services.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Parser;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Util;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    public static List<DetailInfo> parseDetail(BankDetailRequest bankDetailRequest, String rspStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element ebenk = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = FJHXB_Parser.parserCommonInfo(ebenk);
        Element body = ebenk.getChild("Body");
        if (FJHXB_Util.SUCCESS_CODE.equalsIgnoreCase(rsp.getResponseCode())) {
            List list = body.getChild("List").getChild("Map").getChild("List").getChildren("Map");
            if (list == null || list.size() == 0) {
                return detailList;
            }
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Element row : list) {
                DetailInfo detail = new DetailInfo();
                String currencyCode = row.getChildTextTrim("CurrencyCode");
                detail.setCurrency(currencyCode);
                String payeeAcNo = row.getChildTextTrim("PartnerAcct");
                String payeeAcName = row.getChildTextTrim("PartnerAcName");
                String payeeBankName = row.getChildTextTrim("PartnerBankName");
                detail.setOppAccNo(payeeAcNo);
                detail.setOppAccName(payeeAcName);
                detail.setOppBankName(payeeBankName);
                detail.setAccName(acnt.getAccName());
                detail.setAccNo(acnt.getAccNo());
                String transferDate = row.getChildTextTrim("TransDate");
                detail.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                String JnlNo = row.getChildTextTrim("JnlNo");
                String DtlSeqNum = row.getChildTextTrim("DtlSeqNum");
                detail.setBankDetailNo(JnlNo + DtlSeqNum);
                String transferTime = row.getChildTextTrim("TransTime");
                if (StringUtils.isNotEmpty((String)transferTime) && transferTime.length() > 6) {
                    detail.setTransTime(LocalDateTime.parse(transferTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                } else {
                    detail.setTransTime(LocalDateTime.parse(transferDate + transferTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
                String payAmount = row.getChildTextTrim("Amount");
                String recAmount = row.getChildTextTrim("Amount");
                BigDecimal payAmountD = new BigDecimal(payAmount);
                BigDecimal recAmountD = new BigDecimal(recAmount);
                String CDFlag = row.getChildTextTrim("DCFlag");
                if (CDFlag.equalsIgnoreCase("D")) {
                    detail.setDebitAmount(payAmountD);
                    detail.setCreditAmount(new BigDecimal(0));
                } else if (CDFlag.equalsIgnoreCase("C")) {
                    detail.setDebitAmount(new BigDecimal(0));
                    detail.setCreditAmount(recAmountD);
                } else {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u610f\u5916\u7684\u501f\u8d37\u6807\u8bc6\uff1a%s\u3002", (String)"DetailParser_0", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), CDFlag));
                }
                String AcctBal = row.getChildTextTrim("Balance");
                if (StringUtils.isNotEmpty((String)AcctBal)) {
                    BigDecimal balance = new BigDecimal(AcctBal);
                    detail.setBalance(balance);
                }
                String AttachInfo = row.getChildTextTrim("AttachInfo");
                String Remark = row.getChildTextTrim("Remark");
                detail.setExplanation(AttachInfo + (StringUtils.isEmpty((String)AttachInfo) ? "" : " ") + Remark);
                if (!StringUtils.isEmpty((String)AttachInfo) && AttachInfo.contains(FJHXB_Util.KD_FLAG)) {
                    detail.setPayBankDetailSeqID(AttachInfo.substring(0, AttachInfo.indexOf(FJHXB_Util.KD_FLAG)));
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                detail.setJsonMap(jsonStr);
                String rNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonStr);
                if (countMap.containsKey(rNo)) {
                    int count = (Integer)countMap.get(rNo) + 1;
                    countMap.put(rNo, count);
                    rNo = rNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(rNo, 0);
                }
                detail.setReceiptNo(rNo);
                detail.setSortField(detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE) + DtlSeqNum);
                detailList.add(detail);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)(rsp.getResponseMessage() + "\uff0c" + rsp.getResponseCode()));
        }
        return detailList;
    }
}

