/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccbasia.ccip.services;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import org.jdom2.Element;

public class CommonPacker {
    public static Element packCommonHeader(String sysTXCode, String sequence, String traceID, String nextPage) {
        IParameter parameter = EBContext.getContext().getParameter();
        Element root = new Element("Transaction_Header");
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_TX_CODE", (String)sysTXCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_REQ_LEN", (String)"1021");
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("hhmmssSSS");
        try {
            JDomExtUtils.addChildCDData((Element)root, (String)"SYS_REQ_TIME", (String)dateFormat.format(LocalDateTime.now()));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u65f6\u95f4\u51fa\u9519\u3002", (String)"CommonPacker_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
        }
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_TX_VRSN", (String)"01");
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_DT", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_TM", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        String opNo = parameter.getBankParameter("cusopr");
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_STFF_ID", (String)opNo);
        JDomExtUtils.addChildCDData((Element)root, (String)"MULTI_TENANCY_ID", (String)"CN000");
        JDomExtUtils.addChildCDData((Element)root, (String)"LNG_ID", (String)"zh-cn");
        JDomExtUtils.addChildCDData((Element)root, (String)"REC_IN_PAGE", (String)"100");
        JDomExtUtils.addChildCDData((Element)root, (String)"PAGE_JUMP", (String)nextPage);
        JDomExtUtils.addChildCDData((Element)root, (String)"STS_TRACE_ID", (String)traceID);
        String coustomerNo = parameter.getBankParameter("custid");
        JDomExtUtils.addChildCDData((Element)root, (String)"CHNL_CUST_NO", (String)coustomerNo);
        JDomExtUtils.addChildCDData((Element)root, (String)"IttParty_Jrnl_No", (String)sequence);
        String ip = parameter.getBankParameter("ip");
        JDomExtUtils.addChildCDData((Element)root, (String)"Txn_Itt_IP_Adr", (String)ip);
        return root;
    }

    public static Element packComEntityForAuthority() throws EBServiceException {
        Element root = new Element("request");
        JDomExtUtils.addChildCDData((Element)root, (String)"ASPD_ECD", (String)"00000882");
        JDomExtUtils.addChildCDData((Element)root, (String)"SChl_No", (String)"000000000000000");
        JDomExtUtils.addChildCDData((Element)root, (String)"FwCtl_Node_ID", (String)"000000000000000");
        JDomExtUtils.addChildCDData((Element)root, (String)"IttParty_Bsn_Dt", (String)DateUtil.formatDate((Date)new Date()));
        String grpid = RequestContextUtils.getBankParameterValue((String)"grpid");
        JDomExtUtils.addChildCDData((Element)root, (String)"Grp_ID", (String)grpid);
        String cstid = RequestContextUtils.getBankParameterValue((String)"cstid");
        JDomExtUtils.addChildCDData((Element)root, (String)"Cst_ID", (String)cstid);
        String primarno = RequestContextUtils.getBankParameterValue((String)"primarno");
        JDomExtUtils.addChildCDData((Element)root, (String)"Prim_AR_No", (String)primarno);
        JDomExtUtils.addChildCDData((Element)root, (String)"Root_Node_PdAr_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"PdAr_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"SvM24Hr_Ind", (String)"0");
        JDomExtUtils.addChildCDData((Element)root, (String)"Tmzon_ECD", (String)"08");
        JDomExtUtils.addChildCDData((Element)root, (String)"Rqs_Upload_File_Nm", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"Cmpt_Ent_ID", (String)"0000CN000");
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_BIZ_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_MNPLT_TP", (String)"01");
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_FCN_ID", (String)"02001001");
        String ccsttrid = RequestContextUtils.getBankParameterValue((String)"ccsttrid");
        JDomExtUtils.addChildCDData((Element)root, (String)"CCstTr_ID", (String)ccsttrid);
        String ccstrndid = RequestContextUtils.getBankParameterValue((String)"ccsttrnddid");
        JDomExtUtils.addChildCDData((Element)root, (String)"CCstTrNdID", (String)ccstrndid);
        return root;
    }

    public static Element packCommonHeader(String sysTXCode, String sequence) {
        return CommonPacker.packCommonHeader(sysTXCode, sequence, "", "1");
    }

    public static Element packComEntity(String proCode, String fileName, String sequence) {
        return CommonPacker.packComEntity(proCode, "000000000000000", "000000000000000", fileName, sequence, "01");
    }

    public static Element packComEntity(String proCode, String sequence) {
        return CommonPacker.packComEntity(proCode, "000000000000000", "000000000000000", "", sequence, "01");
    }

    public static Element packComEntity(String proCode, String schlNo, String fwctlNodeID, String fileName, String sequence, String functionCode) {
        IParameter parameter = EBContext.getContext().getParameter();
        Element root = new Element("request");
        JDomExtUtils.addChildCDData((Element)root, (String)"ASPD_ECD", (String)proCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"SChl_No", (String)schlNo);
        JDomExtUtils.addChildCDData((Element)root, (String)"FwCtl_Node_ID", (String)fwctlNodeID);
        JDomExtUtils.addChildCDData((Element)root, (String)"IttParty_Bsn_Dt", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String grpid = parameter.getBankParameter("grpid");
        JDomExtUtils.addChildCDData((Element)root, (String)"Grp_ID", (String)grpid);
        String cstid = parameter.getBankParameter("cstid");
        JDomExtUtils.addChildCDData((Element)root, (String)"Cst_ID", (String)cstid);
        String primarno = parameter.getBankParameter("primarno");
        JDomExtUtils.addChildCDData((Element)root, (String)"Prim_AR_No", (String)primarno);
        JDomExtUtils.addChildCDData((Element)root, (String)"Root_Node_PdAr_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"PdAr_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"SvM24Hr_Ind", (String)"0");
        JDomExtUtils.addChildCDData((Element)root, (String)"Tmzon_ECD", (String)"08");
        JDomExtUtils.addChildCDData((Element)root, (String)"Rqs_Upload_File_Nm", (String)fileName);
        JDomExtUtils.addChildCDData((Element)root, (String)"Cmpt_Ent_ID", (String)"0000CN000");
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_BIZ_ID", (String)sequence);
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_MNPLT_TP", (String)functionCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_FCN_ID", (String)"");
        String ccsttrid = parameter.getBankParameter("ccsttrid");
        JDomExtUtils.addChildCDData((Element)root, (String)"CCstTr_ID", (String)ccsttrid);
        String ccstrndid = parameter.getBankParameter("ccsttrnddid");
        JDomExtUtils.addChildCDData((Element)root, (String)"CCstTrNdID", (String)ccstrndid);
        return root;
    }
}

