/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccbasia.ccip.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccbasia.ccip.services.CCBASIABankResponse;
import kd.ebg.aqap.banks.ccbasia.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccbasia.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccbasia.ccip.services.LoginUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        LoginUtils.toLogin();
        String currentPage = this.getCurrentPage();
        if ("0".equalsIgnoreCase(currentPage)) {
            currentPage = "1";
            this.setCurrentPage(currentPage);
        }
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSERH3", Sequence.genSequence(), "", this.getCurrentPage());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData((Element)request, (String)"Rvl_Rcrd_Num", (String)"1");
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData((Element)list1, (String)"AccNo", (String)bankDetailRequest.getHeader().getAcnt().getAccNo());
        JDomExtUtils.addChildCDData((Element)list1, (String)"CshEx_Cd", (String)"1");
        JDomExtUtils.addChildCDData((Element)list1, (String)"CcyCd", (String)bankDetailRequest.getBankCurrency());
        JDomExtUtils.addChildCDData((Element)request, (String)"StDt", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData((Element)request, (String)"EdDt", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData((Element)request, (String)"Inst_SvrlLgPsn_ID", (String)RequestContextUtils.getBankParameterValue((String)"inst_svrllgpsn_id"));
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        this.setLastPage(true);
        CCBASIABankResponse rsp = CommonParser.getFrontResponse(rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"DetailImpl_0", (String)"ebg-aqap-banks-ccbasia-ccip", (Object[])new Object[0]), rsp.getResponseCode() + rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBASIABankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String rcrdNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        List detaiList = response.getChildren("LIST1");
        if (!"0".equalsIgnoreCase(rcrdNum)) {
            for (Element node : detaiList) {
                DetailInfo info = new DetailInfo();
                String txDt = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dt");
                String txTm = JDomExtUtils.getChildText((Element)node, (String)"Txn_Tm");
                String detailNo = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dtl_No");
                String dbtCrDrcCd = JDomExtUtils.getChildText((Element)node, (String)"DbtCrDrcCd");
                if (StringUtils.isEmpty((String)txTm)) {
                    txTm = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss"));
                }
                txTm = txDt + txTm;
                info.setTransDate(LocalDate.parse(txTm, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                info.setTransTime(LocalDateTime.parse(txTm, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                String dhamount = JDomExtUtils.getChildText((Element)node, (String)"DHAmt");
                if (!StringUtils.isEmpty((String)dhamount)) {
                    info.setDebitAmount(new BigDecimal(dhamount));
                }
                String cramount = JDomExtUtils.getChildText((Element)node, (String)"Cr_HpnAm");
                String ExoStm_Py_Rmrk = JDomExtUtils.getChildText((Element)node, (String)"ExoStm_Py_Rmrk");
                if (!StringUtils.isEmpty((String)cramount)) {
                    info.setCreditAmount(new BigDecimal(cramount));
                }
                info.setAccNo(bankDetailRequest.getHeader().getAcnt().getAccNo());
                info.setAccName(bankDetailRequest.getHeader().getAcnt().getAccName());
                String currency = JDomExtUtils.getChildText((Element)node, (String)"CcyCd");
                info.setCurrency(currency);
                String cadBankNm = JDomExtUtils.getChildText((Element)node, (String)"CADBank_Nm");
                info.setOppBankName(cadBankNm);
                String orAccNo = JDomExtUtils.getChildText((Element)node, (String)"CntprtAcc");
                info.setOppAccNo(orAccNo);
                String orAccName = JDomExtUtils.getChildText((Element)node, (String)"Cntrprt_AccNm");
                info.setOppAccName(orAccName);
                String bankSequnce = JDomExtUtils.getChildText((Element)node, (String)"CCBS_TxnSrlNo");
                String bnkOnly1IdId = JDomExtUtils.getChildText((Element)node, (String)"Bnk_Only1_ID_ID");
                info.setBankDetailNo(bnkOnly1IdId);
                String Smy_Cd = JDomExtUtils.getChildText((Element)node, (String)"Smy_Cd");
                String Smy = JDomExtUtils.getChildText((Element)node, (String)"Smy");
                if ("0083".equalsIgnoreCase(Smy_Cd)) {
                    info.setKdFlag(null);
                    info.setPayBankDetailSeqID(null);
                }
                info.setExplanation(Smy);
                StringBuilder sortSb = new StringBuilder();
                sortSb.append(txDt).append("|").append(detailNo);
                info.setSortField(sortSb.toString());
                String bal = JDomExtUtils.getChildText((Element)node, (String)"AcBa");
                if (StringUtils.isNotEmpty((String)bal)) {
                    try {
                        info.setBalance(new BigDecimal(bal));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(node);
                info.setJsonMap(jsonStr);
                result.add(info);
            }
            String TOTAL_PAGE = header.getChildTextTrim("TOTAL_PAGE");
            int total_page = Integer.parseInt(TOTAL_PAGE);
            int currentPage = Integer.parseInt(this.getCurrentPage());
            if (currentPage >= total_page) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
                this.setCurrentPage(String.valueOf(currentPage + 1));
            }
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P1CMSERH3";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u6d77\u5916\u6d3b\u671f\u8d26\u6237\u660e\u7ec6", (String)"DetailImpl_1", (String)"ebg-aqap-banks-ccbasia-ccip", (Object[])new Object[0]);
    }
}

