/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccbasia.ccip.services.payment.local;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccbasia.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccbasia.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccbasia.ccip.services.payment.PayParser;
import kd.ebg.aqap.banks.ccbasia.ccip.services.payment.local.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import org.jdom2.Content;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        LoginUtils.toLogin();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSETBX", Sequence.genSequence());
        root.addContent((Content)headr);
        Element req = CommonPacker.packComEntity("10230017", paymentInfo.getBankBatchSeqId());
        body.addContent((Content)req);
        JDomExtUtils.addChildCDData((Element)req, (String)"EBnk_AR_ID", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
        JDomExtUtils.addChildCDData((Element)req, (String)"Pyr_Cst_AccNo", (String)paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData((Element)req, (String)"Pyr_Nm_Adr", (String)paymentInfo.getAccName());
        JDomExtUtils.addChildCDData((Element)req, (String)"CcyCd", (String)CurrencyUtils.convert2Bank((String)paymentInfo.getPayCurrency(), (String)paymentInfo.getBankVersionID(), (String)paymentInfo.getCustomID()));
        JDomExtUtils.addChildCDData((Element)req, (String)"RcvPrt_Cst_AccNo", (String)paymentInfo.getIncomeAccNo());
        JDomExtUtils.addChildCDData((Element)req, (String)"RcvPrt_Nm_Adr", (String)paymentInfo.getIncomeAccName());
        JDomExtUtils.addChildCDData((Element)req, (String)"Rqs_Amt", (String)paymentInfo.getActualAmount().toPlainString());
        JDomExtUtils.addChildCDData((Element)req, (String)"EfDt", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData((Element)req, (String)"Rmrk", (String)paymentInfo.getExplanation());
        JDomExtUtils.addChildCDData((Element)req, (String)"Ovsea_RvPy_Txn_TpCd", (String)"05");
        JDomExtUtils.addChildCDData((Element)req, (String)"ClntEnd_IP_Adr", (String)RequestContextUtils.getBankParameterValue((String)"ip"));
        JDomExtUtils.addChildCDData((Element)req, (String)"CstPty_TxnSrlNo", (String)paymentInfo.getBankDetailSeqID());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rsp) {
        List<PaymentInfo> paymentInfos = PayParser.parserPay(bankPayRequest, rsp);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P1CMSETBX";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5168\u7403\u652f\u4ed8\u5de5\u5382\u9a71\u52a8\u6d77\u5916\u76f4\u8fde\u5355\u7b14\u8f6c\u8d26", (String)"PayImpl_0", (String)"ebg-aqap-banks-ccbasia-ccip", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType()) && "CCB_ASIA_LOCAL".equalsIgnoreCase(paymentInfo.getUseCN());
    }
}

