/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccbasia.ccip.services.payment.tt;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccbasia.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccbasia.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccbasia.ccip.services.payment.PayParser;
import kd.ebg.aqap.banks.ccbasia.ccip.services.payment.local.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class TTPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        CountryISOCode incomeCountryISOCode;
        LoginUtils.toLogin();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSETBY", Sequence.genSequence());
        root.addContent((Content)headr);
        Element req = CommonPacker.packComEntity("10230017", paymentInfo.getBankBatchSeqId());
        body.addContent((Content)req);
        JDomExtUtils.addChildCDData((Element)req, (String)"EBnk_AR_ID", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
        CountryISOCode accCountry = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getAccCountry());
        if (accCountry == null) {
            accCountry = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getAccCountry());
        }
        if ((incomeCountryISOCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry())) == null) {
            incomeCountryISOCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        String transType = "04";
        if (accCountry != null && incomeCountryISOCode != null && accCountry.geteChart3().equalsIgnoreCase(incomeCountryISOCode.geteChart3())) {
            transType = "01";
        } else if (incomeCountryISOCode != null && incomeCountryISOCode.geteChart3().equalsIgnoreCase("CHN") && paymentInfo.is2SameBank()) {
            transType = "02";
        }
        JDomExtUtils.addChildCDData((Element)req, (String)"Ovsea_RvPy_Txn_TpCd", (String)transType);
        JDomExtUtils.addChildCDData((Element)req, (String)"Rqs_Amt", (String)paymentInfo.getActualAmount().toPlainString());
        JDomExtUtils.addChildCDData((Element)req, (String)"CcyCd", (String)CurrencyUtils.convert2Bank((String)paymentInfo.getPayCurrency(), (String)paymentInfo.getBankVersionID(), (String)paymentInfo.getCustomID()));
        JDomExtUtils.addChildCDData((Element)req, (String)"EfDt", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData((Element)req, (String)"OvseaRmtAutoDbt_AccNo", (String)paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData((Element)req, (String)"Pyr_Cst_AccNo", (String)paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData((Element)req, (String)"Pyr_Nm_Adr", (String)paymentInfo.getAccName());
        JDomExtUtils.addChildCDData((Element)req, (String)"RcvPrt_Cst_AccNo", (String)paymentInfo.getIncomeAccNo());
        JDomExtUtils.addChildCDData((Element)req, (String)"RcvPrt_Nm_Adr", (String)paymentInfo.getIncomeAccName());
        JDomExtUtils.addChildCDData((Element)req, (String)"RcvPymtPsSWIFT_Cd", (String)"");
        JDomExtUtils.addChildCDData((Element)req, (String)"RPPDBnkSWIFT_Cd", (String)paymentInfo.getIncomeSwiftCode());
        JDomExtUtils.addChildCDData((Element)req, (String)"IntrBkAcNo", (String)paymentInfo.getProxyAccNo());
        JDomExtUtils.addChildCDData((Element)req, (String)"IBnkSWIFT_No", (String)paymentInfo.getProxyBankSwiftCode());
        JDomExtUtils.addChildCDData((Element)req, (String)"IBnk_Nm_Adr", (String)paymentInfo.getProxyBankName());
        String feeMode = "3";
        if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "0";
        } else if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "2";
        }
        JDomExtUtils.addChildCDData((Element)req, (String)"DstAbrdCst_ChrgTo_Cd", (String)feeMode);
        JDomExtUtils.addChildCDData((Element)req, (String)"Rmt_Pstcrpt", (String)paymentInfo.getExplanation());
        JDomExtUtils.addChildCDData((Element)req, (String)"RcvPymtPs_RtCtyRgn_Cd", (String)(incomeCountryISOCode != null ? incomeCountryISOCode.getNumberCode() : ""));
        JDomExtUtils.addChildCDData((Element)req, (String)"Apl_Psn_Nm", (String)paymentInfo.getApplyName());
        JDomExtUtils.addChildCDData((Element)req, (String)"Aply_Psn_Tel", (String)paymentInfo.getApplyPhone());
        JDomExtUtils.addChildCDData((Element)req, (String)"ClntEnd_IP_Adr", (String)RequestContextUtils.getBankParameterValue((String)"ip"));
        JDomExtUtils.addChildCDData((Element)req, (String)"CstPty_TxnSrlNo", (String)paymentInfo.getBankDetailSeqID());
        JDomExtUtils.addChildCDData((Element)req, (String)"Cmsn_ChrgFee_AccNo", (String)paymentInfo.getPayerFeeAccNo());
        if (StringUtils.isNotEmpty((String)paymentInfo.getPayerFeeCurrency())) {
            JDomExtUtils.addChildCDData((Element)req, (String)"Cost_CcyCd", (String)CurrencyUtils.convert2Bank((String)paymentInfo.getPayerFeeCurrency(), (String)paymentInfo.getBankVersionID(), (String)paymentInfo.getCustomID()));
        }
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rsp) {
        List<PaymentInfo> paymentInfos = PayParser.parserPay(bankPayRequest, rsp);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P1CMSETBY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5168\u7403\u652f\u4ed8\u5de5\u5382\u9a71\u52a8\u6d77\u5916\u76f4\u8fde\u5355\u7b14\u6c47\u6b3e", (String)"TTPayImpl_0", (String)"ebg-aqap-banks-ccbasia-ccip", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType()) && "CCB_ASIA_TT".equalsIgnoreCase(paymentInfo.getUseCN());
    }
}

