/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bnpp.idn.services.payment.rtgs;

import java.math.BigDecimal;
import java.util.List;
import kd.ebg.aqap.banks.bnpp.idn.services.payment.BNPP_CommonPacker;
import kd.ebg.aqap.banks.bnpp.idn.services.payment.querypay.QueryPayImpl;
import kd.ebg.aqap.banks.bnpp.idn.services.utils.BNPPUtils;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    protected String getPayFileName(BankPayRequest bankPayRequest) {
        return BNPPUtils.getFileName();
    }

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Document");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = BNPP_CommonPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn);
        Element PmtInf = BNPP_CommonPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"InstrId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)info.getActualAmount().toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(info.getActualAmount());
            InstdAmt.setAttribute("Ccy", info.getPayCurrency());
            if (info.getPayerFeeType().equalsIgnoreCase("01")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
            } else if (info.getPayerFeeType().equalsIgnoreCase("02")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
            } else if (info.getPayerFeeType().equalsIgnoreCase("03")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
            }
            BNPP_CommonPacker.addCdtrAgt(CdtTrfTxInf, info, ns1);
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)BNPPUtils.formatStringByLength(info.getIncomeAccName(), 140)).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)BNPPUtils.getCountry2Code(info)).setNamespace(ns1);
            if (StringUtils.isNotEmpty((String)info.getIncomeAddress())) {
                JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"AdrLine", (String)info.getIncomeAddress()).setNamespace(ns1);
            }
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)info.getIncomeAccNo()).setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct, (String)"Nm", (String)info.getIncomeAccName()).setNamespace(ns1);
            BNPP_CommonPacker.addPurp(CdtTrfTxInf, info, ns1);
            Element RgltryRptg = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RgltryRptg").setNamespace(ns1);
            BNPP_CommonPacker.addDtls(RgltryRptg, "CZ", "false", ns1);
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)info.getExplanation()).setNamespace(ns1);
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RTGS";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType()) && "RTGS".equalsIgnoreCase(paymentInfo.getUseCN());
    }
}

