/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.h2h.services.handler;

import com.google.common.collect.Lists;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT942Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.aqap.proxy.swift.model.Tag;
import kd.ebg.aqap.proxy.swift.model.field.Field25;
import kd.ebg.aqap.proxy.swift.model.field.Field34F;
import kd.ebg.aqap.proxy.swift.model.field.Field61;
import kd.ebg.aqap.proxy.swift.model.field.Field86;
import kd.ebg.aqap.proxy.swift.utils.SwiftTagsUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DBSSG_H2H_MT942_Handler
extends AbstractMT942Handler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DBSSG_H2H_MT942_Handler.class);

    public void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        String name = file.getName();
        if (!this.isNeedToProcessFile(name)) {
            return;
        }
        try {
            List list = super.readFileContentAsString(file);
            for (SwiftTextBlock aList : list) {
                this.logger.info(aList.getUnParserText());
                this.logger.info("\u94f6\u884c\u65e0\u6cd5\u4fdd\u8bc1MT942\u548cMT940\u6570\u636e\u7684\u4e00\u81f4\u6027\uff0c\u6682\u4e0d\u89e3\u6790MT942\uff0c\u9632\u6b62\u660e\u7ec6\u91cd\u590d");
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u62a5\u544a[%1$s]\u51fa\u9519:%2$s\u3002", (String)"DBSSG_H2H_MT942_Handler_1", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), name, e.getMessage()), (Throwable)e);
        }
    }

    public void parseCurrDetails(SwiftTextBlock swiftTextBlock, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        Field25 field25 = new Field25(swiftTextBlock.getTagValue("25"));
        this.logger.info("Field25:" + field25.toString());
        Field34F field34F = new Field34F(swiftTextBlock.getTagValue("34F"));
        String acntNumber = field25.getComponent1();
        String currency = field34F.getComponent1();
        this.parse61To86Tags(swiftTextBlock, acntNumber, currency, fileName, detailInfoList, payInfoList);
    }

    private void parse61To86Tags(SwiftTextBlock swiftTextBlock, String acntNumber, String currency, String fileName, List<OverseaDetail> detailList, List<PaymentInfo> payInfoList) {
        List tags = swiftTextBlock.getTags();
        int[] tag61Index = SwiftTagsUtils.getTagsIndex((List)tags, (String)"61");
        if (0 == tag61Index.length) {
            return;
        }
        for (int aTag61Index : tag61Index) {
            Field61 field61 = new Field61(((Tag)tags.get(aTag61Index)).getTagValue());
            String onlyId = field61.toString().replaceAll(", ", "");
            onlyId = onlyId.substring(1, onlyId.length() - 1);
            OverseaDetail detail = new OverseaDetail();
            detail.setDetail_no(onlyId);
            detail.setCustomId(EBContext.getContext().getCustomID());
            String today = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String time = today.substring(0, 4) + field61.getComponent2();
            if (!today.equals(time)) {
                this.logger.info(ResManager.loadKDString((String)"\u8be5\u7b14\u660e\u7ec6\u4ea4\u6613\u65e5\u671f\u4e0d\u662f\u4eca\u5929\uff0c\u4e0d\u8fdb\u884c\u89e3\u6790\u3002", (String)"DBSSG_H2H_MT942_Handler_2", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]));
                continue;
            }
            detail.setTxDate(LocalDate.parse(time, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setNumber(acntNumber);
            detail.setPayBankName("DBS");
            detail.setPayBankVersion("DBS_H2H");
            detail.setDetailFileName(fileName);
            detail.setCreatetime(LocalDateTime.now());
            detail.setCurrency(currency);
            detail.setTransType(field61.getComponent6());
            BigDecimal amount = field61.getComponent5AsBigDecimal();
            String creditOrDebit = field61.getComponent3();
            if ("C".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else if ("D".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount);
            } else {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b,\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411\u3002", (String)"DBSSG_H2H_MT942_Handler_3", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), creditOrDebit));
            }
            String custRef = field61.getComponent7() == null ? "" : field61.getComponent7().trim();
            detail.setExtField1(custRef);
            this.logger.info("Field61:" + field61.toString());
            Tag tag86 = SwiftTagsUtils.getTagBetween((List)tags, (String)"86", (int)aTag61Index, (int)(aTag61Index + 1));
            if (null != tag86) {
                this.deal86Tag(tag86, detail);
            }
            detailList.add(detail);
        }
    }

    private void deal86Tag(Tag tag86, OverseaDetail detail) {
        int td;
        int txcd;
        int ob;
        int oa;
        String s;
        int ordp;
        int bb;
        int ba;
        Field86 field86 = new Field86(tag86.getTagValue());
        this.logger.info("Field86:" + field86.toString());
        StringBuilder str = new StringBuilder();
        List fields = field86.getComponents();
        for (String fie : fields) {
            if (StringUtils.isEmpty((String)fie) || "null".equals(fie)) continue;
            str.append(fie);
        }
        String explanation = "";
        Object[] split = str.toString().split("\\?");
        ArrayList field86Lists = Lists.newArrayList((Object[])split);
        String benefitAccName = "";
        String benefitAccNo = "";
        String benefitBankName = "";
        int benm = field86Lists.indexOf("BENM");
        if (benm != -1) {
            benefitAccName = (String)field86Lists.get(benm + 1);
        }
        if ((ba = field86Lists.indexOf("BA")) != -1) {
            benefitAccNo = (String)field86Lists.get(ba + 1);
        }
        if ((bb = field86Lists.indexOf("BB")) != -1) {
            benefitBankName = (String)field86Lists.get(bb + 1);
        }
        if ((ordp = field86Lists.indexOf("ORDP")) != -1 && StringUtils.isNotEmpty((String)(s = (String)field86Lists.get(ordp + 1))) && s.length() > 35) {
            benefitAccName = s.substring(0, 35).trim();
        }
        if ((oa = field86Lists.indexOf("OA")) != -1) {
            benefitAccNo = (String)field86Lists.get(oa + 1);
        }
        if ((ob = field86Lists.indexOf("OB")) != -1) {
            benefitBankName = (String)field86Lists.get(ob + 1);
        }
        if ((txcd = field86Lists.indexOf("TXCD")) != -1) {
            explanation = (String)field86Lists.get(txcd + 1);
        }
        if (StringUtils.isEmpty((String)explanation) && (td = field86Lists.indexOf("TD")) != -1) {
            explanation = (String)field86Lists.get(td + 1);
        }
        if (StringUtils.isEmpty((String)explanation)) {
            explanation = str.toString();
        }
        detail.setBenefitAccName(benefitAccName);
        detail.setBenefitAccNo(benefitAccNo);
        detail.setBenefitBankName(benefitBankName);
        detail.setExplanation(explanation);
        if ("NONREF".equalsIgnoreCase(detail.getBenefitAccName())) {
            detail.setBenefitAccName("");
        }
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return fileName.contains("MT942");
    }
}

