/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsb.dc.service.balance.TodayBalanceImpl;
import kd.ebg.aqap.banks.hsb.dc.service.detail.DetailImpl;
import kd.ebg.aqap.banks.hsb.dc.service.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.hsb.dc.service.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.hsb.dc.service.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.banks.hsb.dc.service.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.hsb.dc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary.I200100;
import kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary.SalaryPayImpl;
import kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class HsbDcMetaDataImpl
extends FBEMetaDataTemplate
implements BankMetaDataCollector {
    public static final String CORP_NO = "CORP_NO";
    public static final String waiting4Data = "waiting4Data";
    public static final String filePort = "filePort";

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{TodayBalanceImpl.class, DetailImpl.class, AllocationPayImpl.class, AllocationQueryPayImpl.class, CompanyPayImpl.class, CompanyQueryPayImpl.class, SalaryPayImpl.class, SalaryQueryPayImpl.class, I200100.class, PretreatmentImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return new ArrayList<Class<? extends IBankBatchSeqIDCreator>>();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return new ArrayList<Class<? extends IBankDetailSeqIDCreator>>();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public void baseConfigInit() {
        this.setExchangeProtocol("HTTP");
        this.setTimeOut(3);
        this.setCharSet("GBK");
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u5fbd\u5546\u94f6\u884c", (String)"HsbDcMetaDataImpl_0", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]));
        this.setBankVersionID("HSB_DC");
        this.setBankShortName("HSB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u5fbd\u5546\u94f6\u884c\u76f4\u8054\u7248", (String)"HsbDcMetaDataImpl_1", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u5fbd\u5546\u94f6\u884c", (String)"HsbDcMetaDataImpl_0", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getFrontProxyConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"frontProxy_Port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\u53f7", "LzccbDcMetaDataImpl_6", "ebg-aqap-banks-lzccb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u7684\u7aef\u53e3\u53f7", "LzccbDcMetaDataImpl_7", "ebg-aqap-banks-lzccb-dc"), (String)"", (boolean)false, (boolean)false).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"frontProxyProtocol", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u5668\u901a\u8baf\u534f\u8bae", "LzccbDcMetaDataImpl_8", "ebg-aqap-banks-lzccb-dc"), (String)"HTTP").set2ReadOnly().setHidden(Boolean.valueOf(true)), BankLoginConfigUtil.getMlBankLoginConfig((String)"frontProxy_timeOut", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u5668\u8d85\u65f6\u65f6\u95f4(\u5355\u4f4d\uff1a\u5206\u949f)", "LzccbDcMetaDataImpl_9", "ebg-aqap-banks-lzccb-dc"), (String)"5").setHidden(Boolean.valueOf(true))});
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        List list = super.getBankFrontConfig();
        list.add(BankLoginConfigUtil.getMlBankLoginConfig((String)waiting4Data, (MultiLangEnumBridge)new MultiLangEnumBridge("\u83b7\u53d6\u6587\u4ef6\u6d41\u8bfb\u53d6\u8fc7\u7a0b\u4e2d\u7b49\u5f85\u65f6\u95f4\u95f4\u9694\uff08\u5355\u4f4d\uff1a\u6beb\u79d2\uff09\u3002", "HsbDcMetaDataImpl_13", "ebg-aqap-banks-hsb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u4f01\u7b49\u5f85\u94f6\u884c\u6216\u94f6\u884c\u524d\u7f6e\u673a\u751f\u6210\u6587\u4ef6\u54cd\u5e94\u7684\u65f6\u95f4\u95f4\u9694\uff0c\u7528\u4e8e\u6587\u4ef6\u751f\u6210\u65f6\u95f4\u4e0d\u56fa\u5b9a\u65f6\u4fdd\u969c\u94f6\u4f01\u53ef\u4ee5\u6b63\u786e\u65f6\u95f4\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u3002", "HsbDcMetaDataImpl_14", "ebg-aqap-banks-hsb-dc"), (String)"500").set2Nullable().set2Integer());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BankLoginConfig bankLoginConfig = (BankLoginConfig)iterator.next();
            if (!"exchangeProtocol".equals(bankLoginConfig.getKey().getBankConfigId())) continue;
            iterator.remove();
        }
        BankLoginConfig mlBankLoginConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangeProtocol", (MultiLangEnumBridge)new MultiLangEnumBridge("\u901a\u8baf\u534f\u8bae", "HsbDcMetaDataImpl_22", "ebg-aqap-banks-hsb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("", "CmbHKMetaDataImpl_24", "ebg-aqap-banks-cmb-hk"), Arrays.asList(new MultiLangEnumBridge("TCP", "", ""), new MultiLangEnumBridge("HTTP", "", "")), (String)"HTTP", (boolean)false, (boolean)false, (boolean)false);
        list.add(mlBankLoginConfig);
        return list;
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)CORP_NO, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u53f7", "HsbDcMetaDataImpl_4", "ebg-aqap-banks-hsb-dc")).set2Nullable()});
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("tr_acdt", DetailUniqueTypeEnum.STRING.getType());
        result.put("host_serial_no", DetailUniqueTypeEnum.STRING.getType());
        result.put("crdr_flag", DetailUniqueTypeEnum.STRING.getType());
        result.put("amt", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }

    public boolean isDetailSupportMultiCurrency() {
        return true;
    }

    public Map<String, Map<String, String>> getDetailNoRule() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        HashMap ruleMap = Maps.newHashMapWithExpectedSize((int)16);
        ruleMap.put("accNo", "accNo");
        ruleMap.put("oppAccNo", "oppAcntNumber");
        ruleMap.put("transDate", "transDate");
        ruleMap.put("Amount", "amt");
        ruleMap.put("cdFlag", "crdr_flag");
        ruleMap.put("serialNo", "host_serial_no");
        result.put("default", ruleMap);
        return result;
    }
}

