/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsb.dc.HSB_DC_Packer;
import kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary.Dtl;
import kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary.QueryPayParser;
import kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class I200100
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 5000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = HSB_DC_Packer.buildHead(this.getBizCode(), Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        JDomUtils.addChild((Element)body, (String)"start_date", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)paymentInfo.getSubmitSuccessTime().plusDays(1L).format(DateTimeFormatter.BASIC_ISO_DATE));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Dtl dtl = QueryPayParser.parse(paymentInfos, s);
        if (dtl.getRecordNum() == 0) {
            return new EBBankPayResponse(paymentInfos);
        }
        int recordNum = dtl.getRecordNum();
        int fieldNum = dtl.getFieldNum();
        String[] dataLines = dtl.getDataLines();
        for (int i = 1; i <= recordNum; ++i) {
            String batch_no = dataLines[fieldNum * i + 1];
            if (!paymentInfo.getPackageId().equalsIgnoreCase(batch_no)) continue;
            String serial_no = dataLines[fieldNum * i];
            for (PaymentInfo info : paymentInfos) {
                info.setBankRefID(serial_no);
                info.setQueryImplClassName("kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary.SalaryQueryPayImpl");
            }
            break;
        }
        if (!StringUtils.isEmpty((String)paymentInfo.getBankRefID())) {
            return new SalaryQueryPayImpl().doBiz(bankPayRequest);
        }
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u3002", (String)"I200100_0", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)"", (String)"");
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "200100";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", "GBK");
    }
}

