/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsb.dc.HSB_DC_Parser;
import kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary.Dtl;
import kd.ebg.aqap.banks.hsb.dc.service.proxy.QueryPayFileDownLoad;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public static EBBankPayResponse parseQueryPay(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)(rspStr = rspStr.substring(rspStr.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        logger.info("\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equalsIgnoreCase(record_num)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u653e\u56de\u7684\u8bb0\u5f55\u6570\u4e3a0\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001\u3002", (String)"QueryPayParser_10", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        String[] splits = new String[]{};
        if ("1".equalsIgnoreCase(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            QueryPayFileDownLoad queryPayFileDownLoad = new QueryPayFileDownLoad();
            String content = queryPayFileDownLoad.doBiz(file_name);
            splits = StringUtils.split((String)content, (String)"|");
        } else {
            String serial_record = body.getChildTextTrim("serial_record");
            splits = StringUtils.split((String)serial_record, (String)"|");
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String msg = "";
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        for (int i = 1; i <= recordNum; ++i) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < fieldNum; ++j) {
                buffer.append(splits[fieldNum * i + j].trim());
                buffer.append("|");
            }
            msg = buffer.toString();
            logger.info("\u7b2c{}\u6761\u4ed8\u6b3e\u6570\u636e\u7684\u5185\u5bb9\uff1a{}", new Object[]{i, msg});
            String STAT = splits[fieldNum * i + 9];
            String BATCH_NO = splits[fieldNum * i + 11];
            String CARD_NO = splits[fieldNum * i + 1];
            String ACNAME = splits[fieldNum * i + 3];
            String AMT = splits[fieldNum * i + 5];
            String ERR_MSG = splits[fieldNum * i + 10];
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(CARD_NO, ACNAME, AMT);
            bankResPaymentInfo.setBankStatus(STAT);
            bankResPaymentInfo.setBankMsg(ERR_MSG);
            if ("6".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else if ("9".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("3".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)paymentInfos.get(0).getBankBatchSeqID());
        return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo));
    }

    public static Dtl parse(List<PaymentInfo> paymentInfos, String s) {
        String[] splits;
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)(s = s.substring(s.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new Dtl();
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equalsIgnoreCase(record_num)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u653e\u56de\u7684\u8bb0\u5f55\u6570\u4e3a0\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001\u3002", (String)"QueryPayParser_10", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new Dtl();
        }
        if ("1".equalsIgnoreCase(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            QueryPayFileDownLoad queryPayFileDownLoad = new QueryPayFileDownLoad();
            String content = queryPayFileDownLoad.doBiz(file_name);
            splits = StringUtils.split((String)content, (String)"|");
        } else {
            String serial_record = body.getChildTextTrim("serial_record");
            splits = StringUtils.split((String)serial_record, (String)"|");
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        return new Dtl(recordNum, fieldNum, splits);
    }
}

