/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wechat.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.wechat.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.wechat.dc.util.RequestUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        ArrayList result = new ArrayList(8);
        long days = 0L;
        if (!startDate.isEqual(endDate)) {
            days = endDate.toEpochDay() - startDate.toEpochDay();
        }
        int i = 0;
        while ((long)i <= days) {
            request.setEndDate(request.getStartDate());
            EBBankDetailResponse ebBankDetailResponse = this.doBiz(request);
            result.addAll(ebBankDetailResponse.getDetails());
            request.setStartDate(request.getStartDate().plusDays(1L));
            ++i;
        }
        return new EBBankDetailResponse(result);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        if (BankBusinessConfig.customType((String)request.getAcnt().getAccNo())) {
            return super.doBiz(request);
        }
        List financeAccTypeList = BankBusinessConfig.getFinanceAccType((String)request.getAcnt().getAccNo());
        if (CollectionUtil.isEmpty((Collection)financeAccTypeList)) {
            this.logger.info("\u94f6\u884c\u8d26\u6237\u7c7b\u578b\u914d\u7f6e\u4e3a\u7a7a");
        }
        ArrayList detailInfos = new ArrayList(16);
        for (String accountType : financeAccTypeList) {
            EBBankDetailResponse ebBankDetailResponse = this.queryJNPTSH(request, accountType);
            List details = ebBankDetailResponse.getDetails();
            detailInfos.addAll(details);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EBBankDetailResponse queryJNPTSH(BankDetailRequest request, String accountType) {
        String requestStr = this.packJNPTSH(request, accountType);
        Map<String, Object> certInfo = RequestUtil.getCertInfo(request.getAcnt().getAccNo());
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])certInfo.get("key"));){
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            String password = (String)certInfo.get("pwd");
            String encoding = RequestContextUtils.getCharset();
            keyStore.load(inputStream, password.toCharArray());
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            };
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password.toCharArray()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1", "TLSv1.2"}, null, hostnameVerifier);
            int timeOut = Integer.parseInt(RequestContextUtils.getBankParameterValue((String)"timeout"));
            RequestConfig config = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(timeOut * 60 * 1000).build();
            CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            String ip = RequestContextUtils.getBankParameterValue((String)"ip");
            String normalUri = "/pay/downloadfundflow";
            HttpPost httpPost = new HttpPost("https://" + ip + normalUri);
            StringEntity entityParams = new StringEntity(requestStr, encoding);
            this.logger.infoFilerLog("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestStr);
            httpPost.setEntity((HttpEntity)entityParams);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
            String rspStr = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)encoding);
            this.logger.info("\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
            EBBankDetailResponse eBBankDetailResponse = this.parseJNPTSH(request, rspStr);
            return eBBankDetailResponse;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            this.logger.info("\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankDetailRequest request) {
        String sub_mch_id;
        LocalDate endDate;
        LocalDate startDate = request.getStartDate();
        if (!DateUtil.isSameDay((LocalDate)startDate, (LocalDate)(endDate = request.getEndDate()))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u540c\uff0c\u5fae\u4fe1\u5bf9\u8d26\u5355\u63a5\u53e3\u4e00\u6b21\u53ea\u80fd\u83b7\u53d6\u4e00\u5929\u7684\u6570\u636e\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        Element root = new Element("xml");
        String accNo = request.getAcnt().getAccNo();
        HashMap<String, String> map = new HashMap<String, String>(16);
        String appid = BankBusinessConfig.getAppId((String)accNo);
        if (StringUtils.isEmpty((String)appid)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u670d\u52a1\u5546\u5546\u6237APPID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684\u94f6\u4f01\u8d26\u6237\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"appid", (String)appid);
        map.put("appid", appid);
        String mch_id = BankBusinessConfig.getBusinessId((String)accNo);
        if (StringUtils.isEmpty((String)mch_id)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684\u94f6\u4f01\u8d26\u6237\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"mch_id", (String)mch_id);
        map.put("mch_id", mch_id);
        JDomUtils.addChild((Element)root, (String)"bill_date", (String)startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        map.put("bill_date", startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"bill_type", (String)"ALL");
        map.put("bill_type", "ALL");
        String sub_appid = BankBusinessConfig.getSubAppId((String)accNo);
        if (!StringUtils.isEmpty((String)sub_appid)) {
            JDomUtils.addChild((Element)root, (String)"sub_appid", (String)sub_appid);
            map.put("sub_appid", sub_appid);
        }
        if (!StringUtils.isEmpty((String)(sub_mch_id = BankBusinessConfig.getSubBusinessId((String)accNo)))) {
            JDomUtils.addChild((Element)root, (String)"sub_mch_id", (String)sub_mch_id);
            map.put("sub_mch_id", sub_mch_id);
        }
        String nonce_str = Sequence.gen18Sequence();
        JDomUtils.addChild((Element)root, (String)"nonce_str", (String)nonce_str);
        map.put("nonce_str", nonce_str);
        String key = BankBusinessConfig.getSignKey((String)accNo);
        if (StringUtils.isEmpty((String)key)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684\u94f6\u4f01\u8d26\u6237\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"sign", (String)RequestUtil.sign(map, key));
        String encoding = RequestContextUtils.getCharset();
        String requestParams = JDomUtils.root2String((Element)root, (String)encoding);
        return requestParams;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        if (responseStr.contains("<xml>")) {
            Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
            String returnCode = root.getChildText("return_code");
            String returnMsg = root.getChildText("return_msg");
            String errorCode = root.getChildText("error_code");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5fae\u4fe1\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u5fae\u4fe1\u8fd4\u56de\u72b6\u6001\u7801\uff1a%1$s\uff0c\u5931\u8d25\u9519\u8bef\u7801\uff1a%2$s\uff0c\u9519\u8bef\u7801\u63cf\u8ff0\uff1a%3$S", (String)"DetailImpl_12", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]), returnCode, errorCode, returnMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        BankAcnt acnt = request.getAcnt();
        String[] result = responseStr.split("\\n");
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(result.length);
        try {
            for (int i = 0; i < result.length; ++i) {
                if (i < 1) continue;
                String[] strs = result[i].replace("`", "").split(",");
                if (!ResManager.loadKDString((String)"\u603b\u4ea4\u6613\u5355\u6570", (String)"DetailImpl_7", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]).equalsIgnoreCase(strs[0])) {
                    DetailInfo info = new DetailInfo();
                    String transTime = strs[0].replaceAll("\uff1a", ":");
                    info.setTransDate(LocalDate.parse(transTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    info.setTransTime(LocalDateTime.parse(transTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    info.setId(Sequence.gen18Sequence());
                    info.setBankVersionID(acnt.getBankVersionId());
                    info.setBankLoginID(acnt.getBankLoginId());
                    info.setCurrency(acnt.getCurrency());
                    info.setImplClassName(DetailImpl.class.getName());
                    info.setHistory(Boolean.valueOf(true));
                    BigDecimal big = new BigDecimal(strs[12]);
                    if (big.compareTo(BigDecimal.ZERO) == 0) {
                        info.setDebitAmount(BigDecimal.ZERO);
                        info.setCreditAmount(BigDecimal.ZERO);
                    } else if (big.compareTo(BigDecimal.ZERO) > 0) {
                        info.setDebitAmount(BigDecimal.ZERO);
                        info.setCreditAmount(big.abs());
                    } else {
                        info.setDebitAmount(big.abs());
                        info.setCreditAmount(BigDecimal.ZERO);
                    }
                    info.setUseCn(ResManager.loadKDString((String)"\u7f51\u4e0a\u652f\u4ed8", (String)"DetailImpl_8", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
                    info.setAccNo(acnt.getAccNo());
                    info.setAccName(acnt.getAccName());
                    info.setBankName(acnt.getBankName());
                    info.setOppBankName(strs[10]);
                    info.setTransType("normal");
                    info.setExplanation(strs[20]);
                    info.setBusType(strs[8]);
                    info.setBizRefNo(strs[5]);
                    String serviceCharge = strs[22];
                    BigDecimal charge = new BigDecimal(serviceCharge);
                    info.setTransferCharge(charge.abs().setScale(2, 1));
                    String transNo = strs[5];
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("transTime", (Object)strs[0]);
                    jsonObject.put("amount", (Object)strs[12]);
                    jsonObject.put("transNo", (Object)transNo);
                    info.setJsonMap(jsonObject.toString());
                    info.setBankDetailNo(transNo);
                    list.add(info);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u5fae\u4fe1\u5bf9\u8d26\u5355\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u5fae\u4fe1\u5bf9\u8d26\u5355\u53d1\u751f\u5f02\u5e38\u3002", (String)"DetailImpl_9", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]), (Throwable)e);
        }
        EBBankDetailResponse ebBankDetailResponse = new EBBankDetailResponse();
        ebBankDetailResponse.setDetails(list);
        return ebBankDetailResponse;
    }

    public String packJNPTSH(BankDetailRequest request, String accountType) {
        LocalDate startDate = request.getStartDate();
        Element root = new Element("xml");
        String accNo = request.getAcnt().getAccNo();
        HashMap<String, String> map = new HashMap<String, String>();
        String appid = BankBusinessConfig.getAppId((String)accNo);
        if (StringUtils.isEmpty((String)appid)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u670d\u52a1\u5546\u5546\u6237APPID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684\u94f6\u4f01\u8d26\u6237\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"appid", (String)appid);
        map.put("appid", appid);
        String mch_id = BankBusinessConfig.getBusinessId((String)accNo);
        if (StringUtils.isEmpty((String)mch_id)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684\u94f6\u4f01\u8d26\u6237\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"mch_id", (String)mch_id);
        map.put("mch_id", mch_id);
        String nonce_str = Sequence.gen18Sequence();
        JDomUtils.addChild((Element)root, (String)"nonce_str", (String)nonce_str);
        map.put("nonce_str", nonce_str);
        JDomUtils.addChild((Element)root, (String)"bill_date", (String)startDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        map.put("bill_date", startDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)root, (String)"account_type", (String)accountType);
        map.put("account_type", accountType);
        String key = BankBusinessConfig.getSignKey((String)accNo);
        if (StringUtils.isEmpty((String)key)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684\u94f6\u4f01\u8d26\u6237\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"sign", (String)RequestUtil.signBySHA256(map, key));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parseJNPTSH(BankDetailRequest request, String responseStr) {
        if (responseStr.contains("<xml>")) {
            Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
            String returnCode = root.getChildText("return_code");
            String errorCode = root.getChildText("err_code");
            String errorDesc = root.getChildText("return_msg");
            if ("NO_BILL_EXIST".equals(errorCode)) {
                return new EBBankDetailResponse((List)Lists.newArrayList());
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5fae\u4fe1\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u5fae\u4fe1\u8fd4\u56de\u72b6\u6001\u7801\uff1a%1$s\uff0c\u5931\u8d25\u9519\u8bef\u7801\uff1a%2$s\uff0c\u9519\u8bef\u7801\u63cf\u8ff0\uff1a%3$S", (String)"DetailImpl_12", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]), returnCode, errorCode, errorDesc);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        BankAcnt acnt = request.getAcnt();
        String[] result = responseStr.split("\\n");
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>();
        try {
            for (int i = 1; i < result.length; ++i) {
                String[] strs = result[i].replace("`", "").split(",");
                if (!ResManager.loadKDString((String)"\u8d44\u91d1\u6d41\u6c34\u603b\u7b14\u6570", (String)"DetailImpl_13", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]).equals(strs[0])) {
                    DetailInfo info = new DetailInfo();
                    info.setTransDate(LocalDate.parse(strs[0], DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    info.setTransTime(LocalDateTime.parse(strs[0], DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    info.setId(Sequence.gen18Sequence());
                    info.setCurrency(acnt.getCurrency());
                    info.setBusType(strs[4]);
                    BigDecimal amount = new BigDecimal(strs[6]);
                    String flag = strs[5];
                    if (ResManager.loadKDString((String)"\u652f\u51fa", (String)"DetailImpl_14", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]).equals(flag)) {
                        info.setDebitAmount(amount);
                        info.setCreditAmount(BigDecimal.ZERO);
                    } else if (ResManager.loadKDString((String)"\u6536\u5165", (String)"DetailImpl_15", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]).equals(flag)) {
                        info.setDebitAmount(BigDecimal.ZERO);
                        info.setCreditAmount(amount);
                    } else {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6536\u652f\u7c7b\u578b\uff1a%s", (String)"DetailImpl_16", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]), flag));
                    }
                    if (!StringUtils.isEmpty((String)strs[7])) {
                        info.setBalance(new BigDecimal(strs[7]));
                    }
                    info.setAccNo(acnt.getAccNo());
                    info.setAccName(acnt.getAccName());
                    info.setBankName(acnt.getBankName());
                    info.setExplanation(strs[9]);
                    if (!StringUtils.isEmpty((String)strs[4]) && ResManager.loadKDString((String)"\u63d0\u73b0", (String)"DetailImpl_17", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]).equals(strs[4]) && StringUtils.isEmpty((String)strs[9])) {
                        info.setExplanation(ResManager.loadKDString((String)"\u63d0\u73b0", (String)"DetailImpl_17", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
                    }
                    String transNo = strs[1];
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("transTime", (Object)strs[0]);
                    jsonObject.put("amount", (Object)strs[6]);
                    jsonObject.put("transNo", (Object)transNo);
                    info.setJsonMap(jsonObject.toString());
                    info.setBankDetailNo(transNo);
                    list.add(info);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u5fae\u4fe1\u5bf9\u8d26\u5355\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u5fae\u4fe1\u5bf9\u8d26\u5355\u53d1\u751f\u5f02\u5e38\u3002", (String)"DetailImpl_9", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return new EBBankDetailResponse(list);
    }

    public IConnection getConnection(ConnectionFactory factory) {
        String serviceUri = "/pay/downloadbill";
        factory.setUri(serviceUri);
        return super.getConnection(factory);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "wechat_detail";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0b\u8f7d\u5fae\u4fe1\u5bf9\u8d26\u5355\u5e76\u89e3\u6790\u6210\u4ea4\u6613\u660e\u7ec6\u5165\u5e93\u3002", (String)"DetailImpl_10", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]);
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5fae\u4fe1\u4e0d\u652f\u6301\u67e5\u8be2\u5f53\u5929\u7684\u4ea4\u6613\u660e\u7ec6\u3002", (String)"DetailImpl_11", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
    }
}

