/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdnxs.dc.services.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdnxs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.DateUtils;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Packer;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class GroupActDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(GroupActDetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element ebank_root = new Element("Message");
        String currentPage = this.getCurrentPage();
        int page = currentPage.equals("0") ? 1 : Integer.parseInt(currentPage);
        JDomUtils.addChild((Element)ebank_root, (Element)GDNXS_Packer.buildHead((String)this.getBizCode(), (String)Sequence.gen18Sequence()));
        Element body = this.getDetailRequestBody(bankDetailRequest, page + "", "20");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }

    private Element getDetailRequestBody(BankDetailRequest request, String pageTag, String page) {
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)DateUtils.getDate((LocalDate)request.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)DateUtils.getDate((LocalDate)request.getEndDate()));
        JDomUtils.addChild((Element)body, (String)"BeginNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"RecordNum", (String)page);
        return body;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String resp) {
        this.setLastPage(true);
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
        Element head = JDomUtils.string2Root((String)resp, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = GDNXS_Parser.parserCommonInfo((Element)head);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        Element body = head.getChild("Body");
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element lists = body.getChild("List");
            String count = body.getChildText("TotalCount");
            String recordCount = body.getChildText("RecordCount");
            Integer TotleCount = Integer.parseInt(count);
            if (TotleCount == 0) {
                return new EBBankDetailResponse(result);
            }
            this.judgeLastPage(recordCount, count);
            List list = lists.getChildren("Map");
            for (Element row : list) {
                String receiptNo;
                String amount;
                String transTime;
                String hostJnlNo = row.getChildTextTrim("HostJnlNo");
                DetailInfo info = new DetailInfo();
                info.setAccNo(bankDetailRequest.getAcnt().getAccNo());
                info.setAccName(bankDetailRequest.getAcnt().getAccName());
                info.setBankDetailNo(hostJnlNo);
                String transDate = row.getChildTextTrim("TransDate");
                String string = transTime = StringUtils.isEmpty((String)row.getChildTextTrim("TransTime")) ? "000000" : row.getChildTextTrim("TransTime");
                if (StringUtils.isNotEmpty((String)transDate)) {
                    info.setTransDate(LocalDateUtil.parserDate((String)transDate));
                    info.setTransTime(LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
                if (StringUtils.isNotEmpty((String)(amount = row.getChildTextTrim("Amount")))) {
                    BigDecimal judge = new BigDecimal(amount);
                    if (judge.compareTo(BigDecimal.ZERO) >= 0) {
                        info.setCreditAmount(judge);
                        info.setDebitAmount(BigDecimal.ZERO);
                    } else {
                        info.setDebitAmount(judge.abs());
                        info.setCreditAmount(BigDecimal.ZERO);
                    }
                }
                String deptName = row.getChildTextTrim("DeptName");
                info.setBankName(deptName);
                String peerDeptId = row.getChildTextTrim("PeerDeptId");
                info.setOppBankName(peerDeptId);
                String balance = row.getChildTextTrim("Balance");
                if (StringUtils.isNotEmpty((String)balance)) {
                    info.setBalance(new BigDecimal(balance));
                }
                String peerAcNo = row.getChildTextTrim("PeerAcNo");
                info.setOppAccNo(peerAcNo);
                String peerAcName = row.getChildTextTrim("PeerAcName");
                info.setOppAccName(peerAcName);
                String currency = row.getChildTextTrim("Currency");
                info.setCurrency(currency);
                String summary = row.getChildTextTrim("Summary");
                info.setExplanation(summary);
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                if (StringUtils.isNotEmpty((String)jsonStr)) {
                    JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                    jsonObject.put("TransactionDate", (Object)transDate);
                    jsonStr = jsonObject.toJSONString();
                }
                if (countMap.containsKey(receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transDate, jsonStr))) {
                    int countInt = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, countInt);
                    receiptNo = receiptNo + "-" + String.format("%04d", countInt);
                } else {
                    countMap.put(receiptNo, 0);
                }
                info.setReceiptNo(receiptNo);
                info.setJsonMap(jsonStr);
                result.add(info);
            }
            return new EBBankDetailResponse(result);
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25", (String)"", (String)"ebg-receipt-banks-gdnxs-dc", (Object[])new Object[0]));
    }

    public boolean isSupportPage() {
        return true;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EGroupActTrsQry";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/B2EGroupActTrsQry.do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("userPassword")).append("&SIGDATA=0");
        factory.setUri(sb.toString());
    }

    private void judgeLastPage(String recordCount, String totalCount) {
        if (StringUtils.isEmpty((String)recordCount) || StringUtils.isEmpty((String)totalCount)) {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u53c2\u6570recordCount\u4e3a{},totalCount\u4e3a{}\uff0c\u65e0\u6cd5\u5224\u65ad\u672b\u9875", new Object[]{recordCount, totalCount});
            this.setLastPage(true);
            return;
        }
        int recordCountPage = Integer.parseInt(recordCount);
        int totalCountPage = Integer.parseInt(totalCount);
        if (recordCountPage < 20) {
            this.setLastPage(true);
            return;
        }
        String currentPage = this.getCurrentPage();
        int currentPageCount = Integer.parseInt(currentPage);
        if (currentPageCount + 20 > totalCountPage) {
            this.setLastPage(true);
            return;
        }
        this.logger.info("\u672a\u67e5\u8be2\u5b8c");
        this.setLastPage(false);
        this.setCurrentPage(currentPageCount + 20);
    }

    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.isChooseGroupDetail();
    }
}

