/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class A561DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public static final Integer queryNumber = 10;

    public String pack(BankDetailRequest rqst) {
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage)) {
            this.setCurrentPage("1");
        }
        Element body = new Element("body");
        String acntNum = rqst.getAcnt().getAccNo();
        String beginDate = rqst.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String endDate = rqst.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)acntNum);
        JDomUtils.addChild((Element)body, (String)"dateBeginDate", (String)beginDate);
        JDomUtils.addChild((Element)body, (String)"dateEndDate", (String)endDate);
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)queryNumber.toString());
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)this.getCurrentPage());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"A561", (String)signedMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        this.setLastPage(true);
        BankResponse rsp = ParserRsp.parseRsp((String)rspStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            if ("EGG0521".equalsIgnoreCase(rsp.getResponseCode())) {
                ArrayList infos = new ArrayList(0);
                return new EBBankDetailResponse(infos);
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5b9a\u671f\u5b58\u6b3e\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_25", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalCount = JDomUtils.getChildText((Element)body, (String)"totalNumber");
        if (StringUtils.isEmpty((String)totalCount)) {
            totalCount = ParserUtils.getUnNullElementTextValue((Element)body, (String)"totalCount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u603b\u7b14\u6570", (String)"DetailImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        int total = Integer.parseInt(totalCount);
        int nextPageTag = Integer.parseInt(this.getCurrentPage());
        this.setCurrentPage(nextPageTag += queryNumber.intValue());
        this.setLastPage(nextPageTag - 1 >= total);
        String acctNo = body.getChildText("acctNo");
        String currency = body.getChildTextTrim("currency");
        Element lists = body.getChild("lists");
        List list = lists.getChildren("list");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (int i = 0; i < list.size(); ++i) {
            DetailInfo detailInfo = new DetailInfo();
            Element element = (Element)list.get(i);
            String oppositeBankName = element.getChildTextTrim("oppositeBankName");
            detailInfo.setOppBankName(oppositeBankName);
            String subAccount = element.getChildTextTrim("subAccount");
            detailInfo.setOppAccNo(subAccount);
            String tellerJnlNo = element.getChildTextTrim("tellerJnlNo");
            detailInfo.setBankDetailNo(tellerJnlNo);
            String subAcctName = element.getChildTextTrim("subAcctName");
            detailInfo.setOppAccName(subAcctName);
            String remark = element.getChildTextTrim("remark");
            detailInfo.setExplanation(remark);
            String crDtFlag = element.getChildText("debitFlag");
            String amount = element.getChildText("transAmount");
            String oldChannel = element.getChildTextTrim("oldChannel");
            String oldTransCode = element.getChildTextTrim("oldTransCode");
            String oldTransDate = element.getChildTextTrim("oldTransDate");
            String oldEntrustSeqNo = element.getChildTextTrim("oldEntrustSeqNo");
            String oldElecChequeNo = element.getChildTextTrim("oldElecChequeNo");
            String transTime = element.getChildTextTrim("transTime");
            String transDate = element.getChildText("transDate");
            String balance = element.getChildText("acctBalance");
            if ("0".equalsIgnoreCase(crDtFlag)) {
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(new BigDecimal(amount));
            } else if ("1".equalsIgnoreCase(crDtFlag)) {
                detailInfo.setCreditAmount(new BigDecimal(amount));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            }
            detailInfo.setAccNo(acctNo);
            detailInfo.setCurrency(currency);
            try {
                detailInfo.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.BASIC_ISO_DATE));
                if (StringUtils.isEmpty((String)transTime)) {
                    transTime = "000000";
                }
                detailInfo.setTransTime(LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)"time parse error");
            }
            if (StringUtils.isNotEmpty((String)balance)) {
                detailInfo.setBalance(new BigDecimal(balance));
            }
            String serialNo = element.getChildTextTrim("tellerJnlNo");
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String summonsNumber = element.getChildTextTrim("summonsNumber");
            jsonObject.put("seqNum", (Object)summonsNumber);
            jsonObject.put("seqNo", (Object)serialNo);
            jsonObject.put("transTime", (Object)transTime);
            if ("true".equals(RequestContextUtils.getBankParameterValue((String)"api"))) {
                jsonObject.put("Amount", (Object)amount);
                String explanation = jsonStr;
                boolean cashSweep = false;
                if (StringUtils.isNotEmpty((String)explanation)) {
                    cashSweep = this.isCashSweep(explanation, cashSweep);
                }
                if (cashSweep) {
                    jsonObject.put("cdFlag", (Object)"UNKNOW");
                }
                if (BankBusinessConfig.isUseNewApi(bankDetailRequest.getAcnt().getBankLoginId(), RequestContext.get().getTenantId())) {
                    jsonObject.put("cdFlag", (Object)String.format("%s@%s", crDtFlag, summonsNumber));
                }
                jsonStr = jsonObject.toJSONString();
            }
            detailInfo.setJsonMap(jsonObject.toJSONString());
            String accNo = bankDetailRequest.getAcnt().getAccNo();
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailInfos.add(detailInfo);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    private boolean isCashSweep(String explanation, boolean cashSweep) {
        if (explanation.contains(PropertiesConstants.getValue((String)"P00302"))) {
            cashSweep = true;
        }
        if (explanation.contains(PropertiesConstants.getValue((String)"P00301"))) {
            cashSweep = true;
        }
        return cashSweep;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean isSupportPage() {
        return true;
    }

    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.isUseDetailA561();
    }
}

