/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.Check;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    public static final int queryNumber = 20;

    public EBBankDetailResponse commonDetail(BankDetailRequest request) {
        ArrayList result = new ArrayList(1);
        this.setCurrentPage("1");
        boolean isLastPage = false;
        this.setLastPage(false);
        while (!isLastPage) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            if (Objects.nonNull(detailResponse) && Objects.nonNull(detailResponse.getDetails())) {
                if (detailResponse.getDetails().size() == 0) break;
                result.addAll(detailResponse.getDetails());
            }
            int nextTag = Integer.parseInt(this.getCurrentPage());
            this.setCurrentPage(nextTag += 20);
            isLastPage = this.isLastPage();
        }
        return new EBBankDetailResponse(result);
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.commonDetail(request);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.commonDetail(request);
    }

    public String pack(BankDetailRequest request) {
        if ("notice".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return this.packNoticeDepositDetail(request, this.getCurrentPage());
        }
        return this.packDetail(request, this.getCurrentPage());
    }

    public String packDetail(BankDetailRequest rqst, String pageTag) {
        Element body = new Element("body");
        String acntNum = rqst.getAcnt().getAccNo();
        String beginDate = rqst.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String endDate = rqst.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)acntNum);
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)beginDate);
        JDomUtils.addChild((Element)body, (String)"endDate", (String)endDate);
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"20");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)pageTag);
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"8924", (String)signedMsg);
    }

    public String packNoticeDepositDetail(BankDetailRequest rqst, String pageTag) {
        Element body = new Element("body");
        String accNo = rqst.getAcnt().getAccNo();
        String startDate = rqst.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String endDate = rqst.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)startDate);
        JDomUtils.addChild((Element)body, (String)"endDate", (String)endDate);
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)Integer.toString(20));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"FB21", (String)signedMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        if ("notice".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return new EBBankDetailResponse(this.parseNoticeDepositDetail(request, responseStr));
        }
        return new EBBankDetailResponse(this.parseDetail(request, responseStr));
    }

    public List<DetailInfo> parseNoticeDepositDetail(BankDetailRequest rqst, String rspStr) {
        BankResponse rsp = ParserRsp.parseRsp((String)rspStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            if ("EGG0521".equalsIgnoreCase(rsp.getResponseCode())) {
                return new ArrayList<DetailInfo>(16);
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5b9a\u671f\u5b58\u6b3e\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_25", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalCount = JDomUtils.getChildText((Element)body, (String)"totalNumber");
        if (StringUtils.isEmpty((String)totalCount)) {
            totalCount = ParserUtils.getUnNullElementTextValue((Element)body, (String)"totalCount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u603b\u7b14\u6570", (String)"DetailImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        int total = Integer.parseInt(totalCount);
        int nextPageTag = Integer.parseInt(this.getCurrentPage());
        this.setLastPage(nextPageTag >= total);
        Element lists = body.getChild("lists");
        List list = lists.getChildren("list");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (int i = 0; i < list.size(); ++i) {
            DetailInfo detailInfo = new DetailInfo();
            String acctNo = body.getChildText("acctNo");
            String currency = body.getChildTextTrim("currency");
            Element element = (Element)list.get(i);
            String crDtFlag = element.getChildText("crDtFlag");
            String amount = element.getChildText("amount");
            String transDate = element.getChildText("transDate");
            String balance = element.getChildText("balance");
            String subSeqNo = element.getChildText("subSeqNo");
            if ("0".equalsIgnoreCase(crDtFlag)) {
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(new BigDecimal(amount));
            } else if ("1".equalsIgnoreCase(crDtFlag)) {
                detailInfo.setCreditAmount(new BigDecimal(amount));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            }
            detailInfo.setAccNo(acctNo);
            detailInfo.setCurrency(currency);
            try {
                detailInfo.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.BASIC_ISO_DATE));
                detailInfo.setTransTime(LocalDateTime.parse(transDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            catch (Exception e) {
                log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)e);
            }
            if (StringUtils.isNotEmpty((String)balance)) {
                detailInfo.setBalance(new BigDecimal(balance));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("seqNum", (Object)subSeqNo);
            if ("true".equals(RequestContextUtils.getBankParameterValue((String)"api"))) {
                jsonObject.put("Amount", (Object)amount);
                String explanation = jsonStr;
                boolean cashSweep = false;
                if (StringUtils.isNotEmpty((String)explanation)) {
                    cashSweep = this.isCashSweep(explanation, cashSweep);
                }
                if (cashSweep) {
                    jsonObject.put("cdFlag", (Object)"UNKNOW");
                }
                if (BankBusinessConfig.isUseNewApi(rqst.getAcnt().getBankLoginId(), RequestContext.get().getTenantId())) {
                    String seqNum = element.getChildText("subSeqNo");
                    jsonObject.put("cdFlag", (Object)String.format("%s@%s", crDtFlag, seqNum));
                }
                jsonStr = jsonObject.toJSONString();
            }
            detailInfo.setJsonMap(jsonObject.toJSONString());
            String accNo = rqst.getAcnt().getAccNo();
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailInfos.add(detailInfo);
        }
        return detailInfos;
    }

    private List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) {
        BankResponse rsp = ParserRsp.parseRsp((String)rspStr);
        BankAcnt reqAcnt = rqst.getAcnt();
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            if ("EGG0521".equalsIgnoreCase(rsp.getResponseCode())) {
                log.info("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u54cd\u5e94\u7801EGG0521, \u672c\u6b21\u67e5\u8be2\u7ed3\u675f.");
                return new ArrayList<DetailInfo>(16);
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_26", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalCount = JDomUtils.getChildText((Element)body, (String)"totalNumber");
        if (StringUtils.isEmpty((String)totalCount)) {
            totalCount = ParserUtils.getUnNullElementTextValue((Element)body, (String)"totalCount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u603b\u7b14\u6570", (String)"DetailImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        int total = Integer.parseInt(totalCount);
        int nextPageTag = Integer.parseInt(this.getCurrentPage());
        this.setLastPage(nextPageTag >= total || total < 20);
        String acctNo = body.getChildText("acctNo");
        String currency = body.getChildText("currency");
        String stringBuilder = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u8bf7\u6c42\u5e10\u53f7:%s", (String)"DetailImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), reqAcnt.getAccNo()) + String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u603b\u7b14\u6570:%s", (String)"DetailImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), totalCount) + String.format(ResManager.loadKDString((String)"\u5e10\u53f7:%s", (String)"DetailImpl_5", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), acctNo) + String.format(ResManager.loadKDString((String)"\u5e10\u6237\u5e01\u79cd:%s", (String)"DetailImpl_6", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), currency);
        log.info(stringBuilder);
        Element lists = Check.checkNoNullChildElement((Element)body, (String)"lists");
        List localList = lists.getChildren();
        int count = localList.size();
        log.info("lists\u5305\u542b\u7684\u5b50\u8282\u70b9\u6570:" + count);
        ArrayList<DetailInfo> localArrayList = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (int i = 0; i < count; ++i) {
            Element element = (Element)localList.get(i);
            DetailInfo detail = this.parseDetail(element, reqAcnt, currency, countMap);
            if (null == detail) continue;
            localArrayList.add(detail);
        }
        return localArrayList;
    }

    private DetailInfo parseDetail(Element element, BankAcnt acnt, String currency, Map<String, Integer> countMap) {
        String voucherNo = element.getChildText("voucherNo");
        String seqNo = element.getChildText("seqNo");
        String txAmount = ParserUtils.getUnNullElementTextValue((Element)element, (String)"txAmount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_7", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        String balance = element.getChildText("balance");
        String tranFlag = ParserUtils.getUnNullElementTextValue((Element)element, (String)"tranFlag", (String)ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7", (String)"DetailImpl_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        String transDate = ParserUtils.getUnNullElementTextValue((Element)element, (String)"transDate", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailImpl_9", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        String transTime = ParserUtils.getUnNullElementTextValue((Element)element, (String)"transTime", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4", (String)"DetailImpl_10", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        String note = element.getChildText("note");
        String remark = element.getChildText("remark");
        String payeeBankNo = element.getChildText("payeeBankNo");
        String payeeBankName = element.getChildText("payeeBankName");
        String payeeAcctNo = element.getChildText("payeeAcctNo");
        String payeeName = element.getChildText("payeeName");
        String stringBuilder = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\uff1a%s", (String)"DetailImpl_11", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), voucherNo) + String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\uff1a%s", (String)"DetailImpl_12", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), seqNo) + String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d\uff1a%s", (String)"DetailImpl_13", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), txAmount) + String.format(ResManager.loadKDString((String)"\u5e10\u6237\u4f59\u989d\uff1a%s", (String)"DetailImpl_14", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), balance) + String.format(ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7\uff1a%s", (String)"DetailImpl_15", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), tranFlag) + String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\uff1a%s", (String)"DetailImpl_16", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), transDate) + String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\uff1a%s", (String)"DetailImpl_17", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), transTime) + String.format(ResManager.loadKDString((String)"\u5907\u6ce8\uff1a%s", (String)"DetailImpl_18", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), note) + String.format(ResManager.loadKDString((String)"\u6458\u8981\u4ee3\u7801\uff1a%s", (String)"DetailImpl_19", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), remark) + String.format(ResManager.loadKDString((String)"\u5bf9\u65b9\u884c\u53f7\uff1a%s", (String)"DetailImpl_20", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), payeeBankNo) + String.format(ResManager.loadKDString((String)"\u5bf9\u65b9\u884c\u540d\uff1a%s", (String)"DetailImpl_21", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), payeeBankName) + String.format(ResManager.loadKDString((String)"\u5bf9\u65b9\u5e10\u53f7\uff1a%s", (String)"DetailImpl_22", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), payeeAcctNo) + String.format(ResManager.loadKDString((String)"\u5bf9\u65b9\u6237\u540d\uff1a%s", (String)"DetailImpl_23", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), payeeName) + "******\r\n";
        log.info(stringBuilder);
        DetailInfo detail = new DetailInfo();
        detail.setAccName(acnt.getAccName());
        detail.setAccNo(acnt.getAccNo());
        detail.setBankName(acnt.getBankName());
        int index = note.indexOf("_KD_");
        if (!StringUtils.isEmpty((String)note) && index != -1 && "0".equalsIgnoreCase(tranFlag)) {
            String bankDetailSeqId = BizNoUtil.getId((String)note);
            if (bankDetailSeqId.length() > 13) {
                bankDetailSeqId = bankDetailSeqId.substring(bankDetailSeqId.length() - 13);
            }
            note = BizNoUtil.getMsg((String)note);
            detail.setKdFlag(bankDetailSeqId);
            detail.setPayBankDetailSeqID(bankDetailSeqId);
        }
        detail.setUseCn(note);
        detail.setExplanation(note);
        detail.setCurrency(currency);
        StringBuilder buffer = new StringBuilder();
        this.add2Msg(buffer, note);
        this.add2Msg(buffer, remark);
        detail.setExplanation(buffer.toString());
        BigDecimal currBal = this.convert(balance);
        if (null != currBal) {
            detail.setBalance(currBal);
        }
        BigDecimal amount = this.convert(txAmount);
        if ("0".equalsIgnoreCase(tranFlag)) {
            detail.setCreditAmount(new BigDecimal("0.00"));
            detail.setDebitAmount(amount);
        } else if ("1".equalsIgnoreCase(tranFlag)) {
            detail.setCreditAmount(amount);
            detail.setDebitAmount(new BigDecimal("0.00"));
        } else {
            log.info("\u8fd4\u56de\u672a\u77e5\u7684'\u501f\u8d37\u6807\u5fd7':" + tranFlag + ", \u672c\u6761\u6821\u9a8c\u660e\u7ec6\u4e0d\u5904\u7406, \u8bf7\u4eba\u5de5\u6838\u5b9e.");
            return null;
        }
        transTime = StringLength.fixed((String)transTime, (String)"0", (int)6, (boolean)false);
        detail.setTransTime(LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        detail.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.BASIC_ISO_DATE));
        String seqId = element.getChildText("seqNum");
        StringBuilder sortFiled = new StringBuilder();
        sortFiled.append(LocalDateUtil.formatDate((LocalDate)detail.getTransDate())).append("|").append(LocalDateUtil.formatLocalDateTime((LocalDateTime)detail.getTransTime(), (String)"yyyyMMddHHmmss")).append("|").append(String.format("%010d", Integer.parseInt(seqId)));
        detail.setSortField(sortFiled.toString());
        detail.setSortID(sortFiled.toString());
        detail.setOppAccName(payeeName);
        detail.setOppAccNo(payeeAcctNo);
        detail.setOppBankName(payeeBankName);
        String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
        if ("true".equals(RequestContextUtils.getBankParameterValue((String)"api"))) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String explanation = detail.getExplanation();
            boolean cashSweep = false;
            if (StringUtils.isNotEmpty((String)explanation)) {
                cashSweep = this.isCashSweep(explanation, cashSweep);
            }
            if (cashSweep) {
                jsonObject.put("cdFlag", (Object)"UNKNOW");
            }
            if (BankBusinessConfig.isUseNewApi(acnt.getBankLoginId(), RequestContext.get().getTenantId())) {
                String seqNum = element.getChildText("seqNum");
                jsonObject.put("cdFlag", (Object)String.format("%s@%s", tranFlag, seqNum));
            }
            jsonObject.put("Amount", (Object)amount);
            detail.setJsonMap(jsonObject.toJSONString());
            jsonStr = jsonObject.toJSONString();
        } else {
            detail.setJsonMap(jsonStr);
        }
        String accNo = acnt.getAccNo();
        String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
        if (countMap.containsKey(receiptNo)) {
            int count = countMap.get(receiptNo) + 1;
            countMap.put(receiptNo, count);
            receiptNo = receiptNo + "-" + String.format("%04d", count);
        } else {
            countMap.put(receiptNo, 0);
        }
        detail.setReceiptNo(receiptNo);
        detail.setBankDetailNo(seqNo);
        boolean flag1 = StringUtils.isEmpty((String)note);
        boolean flag2 = StringUtils.isEmpty((String)remark);
        String sh = PropertiesConstants.getValue((String)"STMTS_SH");
        String xb = PropertiesConstants.getValue((String)"STMTS_XB");
        String ydbz = PropertiesConstants.getValue((String)"STMTS_YDBZ");
        if (!flag2 && remark.contains(sh)) {
            detail.markTransUp();
        } else if (!flag1 && note.contains(sh)) {
            detail.markTransUp();
        } else if (!flag2 && (remark.contains(xb) || remark.contains(ydbz))) {
            detail.markTransDown();
        } else if (!flag1 && (note.contains(xb) || note.contains(ydbz))) {
            detail.markTransDown();
        }
        return detail;
    }

    private boolean isCashSweep(String explanation, boolean cashSweep) {
        if (explanation.contains(PropertiesConstants.getValue((String)"P00302")) && StringUtils.isNotEmpty((String)PropertiesConstants.getValue((String)"P00302"))) {
            cashSweep = true;
        }
        if (explanation.contains(PropertiesConstants.getValue((String)"P00301")) && StringUtils.isNotEmpty((String)PropertiesConstants.getValue((String)"P00301"))) {
            cashSweep = true;
        }
        return cashSweep;
    }

    private void add2Msg(StringBuilder buffer, String data) {
        if (!StringUtils.isEmpty((String)data)) {
            if (!StringUtils.isEmpty((String)buffer.toString())) {
                buffer.append(";");
            }
            buffer.append(data);
        }
    }

    private BigDecimal convert(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            return new BigDecimal(str);
        }
        return null;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "8924";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u524d\u5e10\u6237\u660e\u7ec6(8924)", (String)"DetailImpl_24", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankDetailRequest request) {
        return !BankBusinessConfig.isUseDetailA561();
    }
}

