/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.company;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyQueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "8804";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u540c\u6b65", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element body = new Element("body");
        if (CommonUtils.isBFJAccount(paymentInfos[0].getIncomeAccNo())) {
            JDomUtils.addChild((Element)body, (String)"transType", (String)"2");
        }
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)paymentInfos[0].getBankBatchSeqID());
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfos[0].getAccNo());
        LocalDateTime submitSuccessTime = paymentInfos[0].getSubmitSuccessTime();
        if (submitSuccessTime == null) {
            submitSuccessTime = LocalDateTime.now();
        }
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)submitSuccessTime.minusDays(15L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"acceptNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"serialNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"1");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)"1");
        JDomUtils.addChild((Element)body, (String)"singleOrBatchFlag", (String)"0");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"8804", (String)signedMsg);
    }

    private Date pre15days(Date now) {
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTime(now);
        localCalendar.set(5, localCalendar.get(5) - 15);
        return localCalendar.getTime();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp((String)responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String totalCount = body.getChildText("totalCount");
            log.info("\u8bf7\u6c42\u67e5\u8be2\u6d41\u6c34\u53f7" + paymentInfos[0].getPackageId() + ", \u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u7b14\u6570:" + totalCount);
            Element listsElement = body.getChild("lists");
            if (null == listsElement) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2d\u672a\u5305\u542blists\u8282\u70b9,\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001.", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
            if (listsElement != null) {
                List lists = listsElement.getChildren();
                int length = lists.size();
                if (0 == length) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2d\u672a\u5305\u542blist\u8282\u70b9,\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001.", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                }
                for (int i = 0; i < length; ++i) {
                    Element element = (Element)lists.get(i);
                    String retElecChequeNo = element.getChildText("elecChequeNo");
                    if (!paymentInfos[0].getPackageId().equalsIgnoreCase(retElecChequeNo)) {
                        log.info("\u94f6\u884c\u8fd4\u56de\u7535\u5b50\u51ed\u8bc1\u53f7" + retElecChequeNo + "\u548c\u8bf7\u6c42\u6d41\u6c34\u53f7" + paymentInfos[0].getPackageId() + "\u4e0d\u4e00\u81f4.");
                        continue;
                    }
                    String transStatus = ParserUtils.getUnNullElementTextValue((Element)element, (String)"transStatus", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
                    String note = ParserUtils.getUnNullElementTextValue((Element)element, (String)"note", (String)ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
                    if ("0".equalsIgnoreCase(transStatus) || "1".equalsIgnoreCase(transStatus) || "2".equalsIgnoreCase(transStatus) || "3".equalsIgnoreCase(transStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)note);
                        continue;
                    }
                    if ("4".equalsIgnoreCase(transStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)"", (String)transStatus, (String)note);
                        continue;
                    }
                    if ("8".equalsIgnoreCase(transStatus) || "9".equalsIgnoreCase(transStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)"", (String)transStatus, (String)note);
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5\u4ea4\u6613\u72b6\u6001\u7801%s\uff0c\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"CompanyQueryPayImpl_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), transStatus), (String)transStatus, (String)note);
                }
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

