/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.foreign;

import com.google.common.collect.Sets;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.foreign.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    private static Map<String, String> costBurdenMap = new HashMap<String, String>(3);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "8931";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"25.8 \u5355\u7b14\u8de8\u5883 8931", (String)"PayImpl_9", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay".equalsIgnoreCase(info.getSubBizType()) && !"01".equalsIgnoreCase(info.getCurrency());
    }

    public Set<String> getSupportCurrency() {
        return Sets.newHashSet((Object[])new String[]{"USD"});
    }

    public String pack(BankPayRequest request) {
        String bordersInOutFlag;
        String payerTakeSendFlag;
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"appointDate", (String)(paymentInfo.getBookingTime() == null ? "" : paymentInfo.getBookingTime().toLocalDate().format(DateTimeFormatter.BASIC_ISO_DATE)));
        PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
        JDomUtils.addChild((Element)body, (String)"electronNumber", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"businessKind", (String)"4");
        JDomUtils.addChild((Element)body, (String)"applyMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        String contactNo = BankBusinessConfig.getContactNo(paymentInfo.getAccNo());
        if (StringUtils.isEmpty((String)contactNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8de8\u5883\u652f\u4ed8\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u8d26\u53f7\u7ba1\u7406\u9644\u52a0\u5c5e\u6027\u4e0a\u7ef4\u62a4", (String)"PayImpl_10", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"contactWay", (String)contactNo);
        String currency = paymentInfo.getCurrency();
        JDomUtils.addChild((Element)body, (String)"payerCurrency", (String)currency);
        String convert2Iso = CurrencyUtils.convert2Iso((String)currency);
        if ("CNY".equalsIgnoreCase(convert2Iso)) {
            payerTakeSendFlag = "0";
            bordersInOutFlag = paymentInfo.is2SameCity() ? "0" : "1";
        } else {
            payerTakeSendFlag = "1";
            bordersInOutFlag = "2";
        }
        JDomUtils.addChild((Element)body, (String)"payerTakeSendFlag", (String)payerTakeSendFlag);
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payerName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"payeeAcctType", (String)"0");
        JDomUtils.addChild((Element)body, (String)"payeeCurrency", (String)currency);
        JDomUtils.addChild((Element)body, (String)"payeeAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"payeeAcctName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"payeeAddress", (String)paymentInfo.getIncomeBankAddress());
        JDomUtils.addChild((Element)body, (String)"receiveBankNo", (String)paymentInfo.getIncomeCnaps());
        if (!StringUtils.isEmpty((String)paymentInfo.getIncomeSwiftCode())) {
            JDomUtils.addChild((Element)body, (String)"receiveBankName", (String)paymentInfo.getIncomeSwiftCode());
        } else {
            JDomUtils.addChild((Element)body, (String)"receiveBankName", (String)paymentInfo.getIncomeBankName());
        }
        JDomUtils.addChild((Element)body, (String)"currency", (String)currency);
        JDomUtils.addChild((Element)body, (String)"amount", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)body, (String)"exchangeAmount", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)body, (String)"costBurden", (String)costBurdenMap.get(paymentInfo.getPayerFeeType()));
        JDomUtils.addChild((Element)body, (String)"ownItBankFlag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"bordersInOutFlag", (String)bordersInOutFlag);
        String paddleMoneyWay = paymentInfo.is2SameBank() ? "0" : "2";
        JDomUtils.addChild((Element)body, (String)"paddleMoneyWay", (String)paddleMoneyWay);
        JDomUtils.addChild((Element)body, (String)"note", (String)CommonUtils.getExplanation(paymentInfo));
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
        if (code == null) {
            code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        JDomUtils.addChild((Element)body, (String)"countryCode", (String)code.geteChart3());
        JDomUtils.addChild((Element)body, (String)"interBanPayCode01", (String)BankBusinessConfig.getInterBanPayCode01(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)body, (String)"note02", (String)"N");
        JDomUtils.addChild((Element)body, (String)"whetherCollatePay", (String)"N");
        JDomUtils.addChild((Element)body, (String)"payRemitNature", (String)"N");
        JDomUtils.addChild((Element)body, (String)"latestShipDate", (String)DateUtil.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)body, (String)"contractNo", (String)"N");
        JDomUtils.addChild((Element)body, (String)"invoiceNo", (String)"N");
        JDomUtils.addChild((Element)body, (String)"registrationnNo", (String)BankBusinessConfig.getRegistrationnNo(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)body, (String)"entryUnitCode", (String)"N");
        JDomUtils.addChild((Element)body, (String)"writePeople", (String)"N");
        JDomUtils.addChild((Element)body, (String)"writePeopleTel", (String)"N");
        JDomUtils.addChild((Element)body, (String)"declareDate", (String)"N");
        JDomUtils.addChild((Element)body, (String)"elsePayAcctNo", (String)"N");
        JDomUtils.addChild((Element)body, (String)"spareFlag", (String)"N");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"8931", (String)signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp((String)responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String backhostStatus = ParserUtils.getUnNullElementTextValue((Element)body, (String)"backhostStatus", (String)ResManager.loadKDString((String)"\u8bb0\u5f55\u72b6\u6001", (String)"PayImpl_11", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            String entrustSeqNo = ParserUtils.getUnNullElementTextValue((Element)body, (String)"entrustSeqNo", (String)ResManager.loadKDString((String)"\u7533\u8bf7\u7f16\u53f7", (String)"PayImpl_12", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            String refuseReason = body.getChildText("refuseReason");
            if ("A".equalsIgnoreCase(backhostStatus) || "B".equalsIgnoreCase(backhostStatus) || "0".equalsIgnoreCase(backhostStatus) || "1".equalsIgnoreCase(backhostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)backhostStatus, (String)"");
                PaymentInfoSysFiled.set((PaymentInfo)paymentInfos[0], (String)"entrustSeqNo", (String)entrustSeqNo);
            } else if ("4".equalsIgnoreCase(backhostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)backhostStatus, (String)"");
                PaymentInfoSysFiled.set((PaymentInfo)paymentInfos[0], (String)"entrustSeqNo", (String)entrustSeqNo);
            } else if ("8".equalsIgnoreCase(backhostStatus) || "9".equalsIgnoreCase(backhostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)"", (String)backhostStatus, (String)refuseReason);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5\u4ea4\u6613\u72b6\u6001\u7801%s\uff0c\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"PayImpl_28", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), backhostStatus), (String)backhostStatus, (String)"");
                PaymentInfoSysFiled.set((PaymentInfo)paymentInfos[0], (String)"entrustSeqNo", (String)entrustSeqNo);
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    static {
        costBurdenMap.put("03", "0");
        costBurdenMap.put("01", "1");
        costBurdenMap.put("02", "3");
    }
}

