/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.individual;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.PayTimeUtils;
import kd.ebg.aqap.banks.spdb.dc.services.payment.SPDBStatus;
import kd.ebg.aqap.banks.spdb.dc.services.payment.individual.RouteQuery;
import kd.ebg.aqap.business.bankstatus.Status;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return RouteQuery.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "8801";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1\u652f\u4ed8, \u5355\u7b14\u652f\u4ed8", (String)"PayImpl_15", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay".equalsIgnoreCase(info.getSubBizType()) && "01".equalsIgnoreCase(info.getCurrency()) && !UseConvertor.isTransfer((PaymentInfo)info) && info.is2Individual();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)paymentInfo.getPackageId());
        if (BankBusinessConfig.isPayByAuthority().booleanValue()) {
            JDomUtils.addChild((Element)body, (String)"authMasterID", (String)CommonUtils.getClientID(request.getAcnt().getAccNo()));
        } else {
            JDomUtils.addChild((Element)body, (String)"authMasterID", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"acctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"bespeakDate", (String)"");
        JDomUtils.addChild((Element)body, (String)"payeeAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"payeeName", (String)paymentInfo.getIncomeAccName());
        if (paymentInfo.is2Individual() && paymentInfo.getIncomeAccNo().length() == 12 && paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"payeeType", (String)"2");
        } else {
            JDomUtils.addChild((Element)body, (String)"payeeType", (String)"1");
        }
        JDomUtils.addChild((Element)body, (String)"payeeBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"payeeAddress", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)body, (String)"amount", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        String remitLocation = "";
        String sysFlag = "";
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"sysFlag", (String)"0");
            sysFlag = "0";
            if (BankBusinessConfig.isSameCityTimeLimitOn().equalsIgnoreCase("3")) {
                remitLocation = "1";
            }
            JDomUtils.addChild((Element)body, (String)"remitLocation", (String)remitLocation);
        } else {
            JDomUtils.addChild((Element)body, (String)"sysFlag", (String)"1");
            sysFlag = "1";
            if (BankBusinessConfig.isSameCityTimeLimitOn().equalsIgnoreCase("1")) {
                if (paymentInfo.is2SameCity() && PayTimeUtils.isSameCityPayTime()) {
                    remitLocation = "0";
                    JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"0");
                } else {
                    remitLocation = "1";
                    JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"1");
                }
            } else if (BankBusinessConfig.isSameCityTimeLimitOn().equalsIgnoreCase("2")) {
                if (paymentInfo.is2SameCity()) {
                    remitLocation = "0";
                    JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"0");
                } else {
                    remitLocation = "1";
                    JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"1");
                }
            } else {
                remitLocation = "1";
                JDomUtils.addChild((Element)body, (String)"remitLocation", (String)"1");
            }
            if ("1".equals(remitLocation) && "1".equals(sysFlag)) {
                String payeeBankSelectFlag = "1";
                String payeeBankNo = paymentInfo.getIncomeCnaps();
                JDomUtils.addChild((Element)body, (String)"payeeBankNo", (String)payeeBankNo);
                JDomUtils.addChild((Element)body, (String)"payeeBankSelectFlag", (String)payeeBankSelectFlag);
            }
        }
        JDomUtils.addChild((Element)body, (String)"note", (String)CommonUtils.getExplanation(paymentInfo));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return this.packToPaymentMsg("8801", signedMsg);
    }

    private String packToPaymentMsg(String txCode, String signature) {
        Element packet = new Element("packet");
        Element head = JDomUtils.addChild((Element)packet, (String)"head");
        JDomUtils.addChild((Element)head, (String)"transCode", (String)txCode);
        JDomUtils.addChild((Element)head, (String)"signFlag", (String)"1");
        JDomUtils.addChild((Element)head, (String)"masterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        JDomUtils.addChild((Element)head, (String)"packetID", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)head, (String)"timeStamp", (String)DateUtil.formatDate4Persion((Date)new Date()));
        Element body = JDomUtils.addChild((Element)packet, (String)"body");
        JDomUtils.addChild((Element)body, (String)"signature", (String)signature);
        String msg = JDomUtils.root2String((Element)packet, (String)RequestContextUtils.getCharset());
        String encoding = RequestContextUtils.getCharset();
        String length = StringLength.getLength4DataWithEncoding((String)msg, (String)encoding) + 6 + "";
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringLength.fixed((String)length, (String)" ", (int)6, (boolean)false));
        buffer.append(msg);
        return buffer.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp((String)responseStr);
        if ("EYY8968".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEYY8968\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"PayImpl_16", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("EGG0044".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEGG0044\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"PayImpl_17", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("EYY8804".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEYY8804\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"PayImpl_18", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("EGG0982".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEGG0982\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"PayImpl_19", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (SPDBStatus.i8801Status.contains(rsp.getResponseCode())) {
            Status status = SPDBStatus.i8801Status.get(rsp.getResponseCode());
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)status.getEbgState(), (String)status.getStatusDesc(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String transStatus = ParserUtils.getUnNullElementTextValue((Element)body, (String)"transStatus", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"PayImpl_20", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            String acceptNo = ParserUtils.getUnNullElementTextValue((Element)body, (String)"acceptNo", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u53d7\u7406\u7f16\u53f7", (String)"PayImpl_21", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            if ("0".equalsIgnoreCase(transStatus) || "1".equalsIgnoreCase(transStatus) || "2".equalsIgnoreCase(transStatus) || "3".equalsIgnoreCase(transStatus) || "8".equalsIgnoreCase(transStatus) || "9".equalsIgnoreCase(transStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayImpl_22", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else if ("4".equalsIgnoreCase(transStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)"");
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5'\u4ea4\u6613\u72b6\u6001'\u7801,\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002\u4ea4\u6613\u53d7\u7406\u7f16\u53f7\u4e3a%s", (String)"PayImpl_29", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), acceptNo), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

