/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.querypay;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.SPDBStatus;
import kd.ebg.aqap.business.bankstatus.Status;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class EY03
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(EY03.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        logger.info("Start EY03 pack");
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"authMasterID", (String)CommonUtils.getClientID(bankPayRequest.getAcnt().getAccNo()));
        JDomUtils.addChild((Element)body, (String)"transType", (String)"");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"seqNo", (String)"");
        LocalDateTime submitSuccessTime = paymentInfo.getSubmitSuccessTime();
        if (submitSuccessTime == null) {
            submitSuccessTime = LocalDateTime.now();
        }
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)submitSuccessTime.minusDays(15L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"1");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)"1");
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)paymentInfo.getBankBatchSeqID());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"EY03", (String)signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        BankResponse rsp = ParserRsp.parseRsp((String)s);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(s);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            Element listsNode = body.getChild("lists");
            paymentInfo.setBankRefID(paymentInfo.getBankBatchSeqID());
            if (Objects.isNull(listsNode)) {
                return new EBBankPayResponse(paymentInfos);
            }
            List lists = listsNode.getChildren("list");
            if (CollectionUtil.isEmpty((Collection)lists)) {
                return new EBBankPayResponse(paymentInfos);
            }
            for (Element element : lists) {
                String retElecChequeNo = element.getChildText("elecChequeNo");
                if (!paymentInfo.getPackageId().equalsIgnoreCase(retElecChequeNo)) continue;
                String transStatus = ParserUtils.getUnNullElementTextValue((Element)element, (String)"transStatus", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
                logger.info("TransStatus: {}", (Object)transStatus);
                if (SPDBStatus.EY03Status.contains(transStatus)) {
                    Status status = SPDBStatus.EY03Status.get(transStatus);
                    logger.info("Contains EY03 Status :{}", (Object)status.toString());
                    ArrayList retry = Lists.newArrayList((Object[])new String[]{"5", "9", "A", "D"});
                    if (retry.contains(status.getStatusCode())) {
                        logger.info("retry");
                        paymentInfo.setBankRefID("");
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)status.getEbgState(), (String)"", (String)status.getStatusCode(), (String)status.getStatusDesc());
                }
                return new EBBankPayResponse(paymentInfos);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "EY03";
    }

    public String getBizDesc() {
        return null;
    }
}

