/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services;

import java.math.BigDecimal;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ExplanationUtil {
    private static final BigDecimal fiftyThousand = new BigDecimal("50000.00");

    public static String convertExplToBank(String explanation, BigDecimal amt) {
        String code = "";
        code = amt.compareTo(fiftyThousand) < 0 ? ExplanationUtil.findSamll(explanation) : ExplanationUtil.findBig(explanation);
        return code;
    }

    private static String findSamll(String explanation) {
        if (StringUtils.isEmpty((String)explanation)) {
            return "311";
        }
        String use = "311";
        String customId = EBContext.getContext().getCustomID();
        String interfaceName = "CostReimb";
        String bankVersion = "CMBC_DC";
        String useCode = UseKeyWordService.getUseByKey((String)customId, (String)explanation, (String)interfaceName, (String)use, (String)bankVersion);
        return useCode;
    }

    private static String findBig(String explanation) {
        if (StringUtils.isEmpty((String)explanation)) {
            return "341";
        }
        String use = "341";
        String customId = EBContext.getContext().getCustomID();
        String interfaceName = "CostReimb";
        String bankVersion = "CMBC_DC";
        String useCode = UseKeyWordService.getUseByKey((String)customId, (String)explanation, (String)interfaceName, (String)use, (String)bankVersion);
        return useCode;
    }

    public static String getExplain(String useCode, PaymentInfo paymentInfo) {
        if (BankBusinessConfig.getDSFK_ZYYT_SFCS() && paymentInfo.is2Individual()) {
            if (StringUtils.isEmpty((String)paymentInfo.getAbstractMsg())) {
                return useCode;
            }
            return String.format("%s|%s", useCode, paymentInfo.getAbstractMsg());
        }
        return String.format("%s|%s", useCode, paymentInfo.getExplanation());
    }

    public static String getExplain(PaymentInfo paymentInfo) {
        String useCode = ExplanationUtil.convertExplToBank(paymentInfo.getExplanation(), paymentInfo.getAmount());
        return ExplanationUtil.getExplain(useCode, paymentInfo);
    }

    public static String getExpOrAbs(PaymentInfo paymentInfo) {
        if (BankBusinessConfig.getDSFK_ZYYT_SFCS() && paymentInfo.is2Individual()) {
            return paymentInfo.getAbstractMsg();
        }
        return paymentInfo.getExplanation();
    }
}

