/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public static EBBankPayResponse parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        try {
            String encoding = RequestContextUtils.getCharset();
            Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
            BankResponse bankResponse = Parser.parseResponse((Element)root);
            if (!"0".equalsIgnoreCase(bankResponse.getResponseCode())) {
                if ("E1602".equalsIgnoreCase(bankResponse.getResponseCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                }
            } else {
                Element xDataBody = root.getChild("xDataBody");
                Element statusId = xDataBody.getChild("statusId");
                if (null == statusId) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684statusId\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)"", (String)"");
                } else {
                    String fileContent;
                    String statusErrMsg;
                    String statusCode = ParserUtils.checkUnNullableElement((Element)statusId, (String)"statusCode");
                    String statusSeverity = statusId.getChildTextTrim("statusSeverity");
                    String msg = statusErrMsg = statusId.getChildTextTrim("statusErrMsg");
                    if (!StringUtils.isEmpty((String)statusSeverity)) {
                        msg = statusSeverity + statusErrMsg;
                    }
                    if (!"0".equalsIgnoreCase(statusCode)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)statusCode, (String)msg);
                        return new EBBankPayResponse((List)Lists.newArrayList((Object[])paymentInfos));
                    }
                    Element batchTransfers = xDataBody.getChild("batchTransfers");
                    if (null == batchTransfers) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684batchTransfers\u8282\u70b9\u4e0d\u5b58\u5728\u3002", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)"", (String)"");
                    }
                    if (batchTransfers != null && StringUtils.isNotEmpty((String)(fileContent = batchTransfers.getChildTextTrim("fileContent")))) {
                        QueryPayParser.parseFileContent(paymentInfos, fileContent);
                    }
                }
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u89e3\u6790\u51fa\u9519:%s\u3002", (String)"QueryPayParser_13", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse((List)Lists.newArrayList((Object[])paymentInfos));
    }

    private static void parseFileContent(PaymentInfo[] paymentInfos, String fileContent) {
        if (StringUtils.isEmpty((String)fileContent)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u5404\u7b14\u4ea4\u6613\u72b6\u6001\u7684\u8282\u70b9<fileContent>\u4fe1\u606f\uff0c\u9700\u8981\u8054\u7cfb\u94f6\u884c\u3002", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)"", (String)"");
            return;
        }
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u8be5\u7b14\u6d41\u6c34\u4ea4\u6613\u7ed3\u679c\u4fe1\u606f\u3002", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)"", (String)"");
        String[] lines = StringUtils.split((String)fileContent, (String)"^");
        for (int i = 0; i < lines.length; ++i) {
            if (StringUtils.isEmpty((String)lines[i])) continue;
            try {
                String txMsg;
                String txCode;
                String seqId;
                String[] fields = StringUtils.split((String)lines[i], (String)"|");
                if (paymentInfos[0].is2SameBank()) {
                    seqId = fields[6];
                    txCode = fields[4];
                    txMsg = fields[5];
                } else {
                    seqId = fields[0];
                    txCode = fields[8];
                    txMsg = fields[9];
                }
                PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)seqId);
                if (null == info) continue;
                info.setBankStatus(txCode);
                info.setBankMsg(txMsg);
                if ("10".equalsIgnoreCase(txCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)txCode, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
                    continue;
                }
                if ("20".equalsIgnoreCase(txCode)) {
                    info.setStatus(Integer.valueOf(PaymentState.FAIL.getId()));
                    info.setStatusMsg(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\u3002", (String)"QueryPayParser_12", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_8", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)txCode, (String)ResManager.loadKDString((String)"\u5931\u8d25", (String)"QueryPayParser_9", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_10", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)txCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u72b6\u6001\u3002", (String)"QueryPayParser_11", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
                continue;
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u7b2c[" + (i + 1) + "]\u884c\u6570\u636e\u51fa\u9519\u3002\u5f85\u89e3\u6790\u6570\u636e\uff1a" + lines[i], (Throwable)e);
            }
        }
    }
}

