/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.inner;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.ExplanationUtil;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker
implements Constants {
    public static String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u5355\u7b14\u8d39\u7528\u62a5\u9500(CostReimb)\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"PayPacker_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createMessageWithHead((String)"CostReimb");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)xdataBody, (String)"acntNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"acntToNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"acntToName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"payeeAcctType", (String)BankBusinessConfig.getPayeeAcctType(paymentInfo.getIncomeAccNo()));
        BigDecimal amt = paymentInfo.getAmount().setScale(2, 4);
        JDomUtils.addChild((Element)xdataBody, (String)"amount", (String)amt.toString());
        JDomUtils.addChild((Element)xdataBody, (String)"explain", (String)ExplanationUtil.getExplain(paymentInfo));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }
}

