/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.link;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.ExplanationUtil;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public static String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u4ea4\u6613(topXfer)\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"PayPacker_4", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createMessageWithHead((String)"topXfer");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfo.getPackageId());
        BankAcntService acntService = BankAcntService.getInstance();
        BankAcnt parentAcc = acntService.selectByAccNo(paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"topAcntNo", (String)parentAcc.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"topAcntName", (String)parentAcc.getAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"acntNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"acntName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"acntToNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"acntToName", (String)paymentInfo.getIncomeAccName());
        String sameBank = true == paymentInfo.is2SameBank() ? "0" : "1";
        JDomUtils.addChild((Element)xdataBody, (String)"externBank", (String)sameBank);
        String localFlagStr = PayPacker.getLocalFlag4Pay(paymentInfo);
        JDomUtils.addChild((Element)xdataBody, (String)"localFlag", (String)localFlagStr);
        if (!paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)xdataBody, (String)"bankCode", (String)paymentInfo.getIncomeCnaps());
        }
        JDomUtils.addChild((Element)xdataBody, (String)"bankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)xdataBody, (String)"bankAddr", (String)paymentInfo.getIncomeBankAddress());
        BigDecimal amt = paymentInfo.getAmount().setScale(2, 4);
        JDomUtils.addChild((Element)xdataBody, (String)"amount", (String)amt.toString());
        JDomUtils.addChild((Element)xdataBody, (String)"explain", (String)ExplanationUtil.getExpOrAbs(paymentInfo));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static String getLocalFlag4Pay(PaymentInfo pay) {
        String payeeCity;
        String payerCity = pay.getAccCity();
        if (PayPacker.isShangHaiCity(payerCity, payeeCity = pay.getIncomeCity()) && pay.is2SameCity()) {
            return "4";
        }
        if (pay.is2SameBank()) {
            if (-1 != payeeCity.indexOf(PropertiesConstants.getValue((String)"BEIJING"))) {
                return "1";
            }
            return pay.is2SameCity() ? "0" : "1";
        }
        if (StringUtils.isEmpty((String)pay.getIncomeCnaps())) {
            return "1";
        }
        BigDecimal amount = pay.getAmount().setScale(2, 4);
        if (BankBusinessConfig.isCyberFlag()) {
            return amount.compareTo(new BigDecimal("1000000.00")) < 0 ? "5" : "3";
        }
        return amount.compareTo(new BigDecimal("1000000.00")) < 0 ? "2" : "3";
    }

    private static boolean isShangHaiCity(String payerCity, String payeeCity) {
        return -1 != payerCity.indexOf(PropertiesConstants.getValue((String)"SHANGHAI")) || -1 != payeeCity.indexOf(PropertiesConstants.getValue((String)"SHANGHAI"));
    }
}

