/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.precheck;

import java.math.BigDecimal;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.ExplanationUtil;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.precheck.BatchCostReimbPaymentImpl;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchCostReimbCrossImpl
extends BatchCostReimbPaymentImpl {
    public String pack(BankPayRequest bankPayRequest) {
        boolean isReimed;
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        PaymentInfo info = paymentInfos[0];
        Element root = Packer.createMessageWithHead((String)"BatchTransferCostReimb");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)xdataBody, (String)"payerAcNo", (String)paymentInfos[0].getAccNo());
        String type = "1";
        String usage = "4111";
        boolean bl = isReimed = info.getUseCN().contains(PropertiesConstants.getValue((String)"CLAIM_PAYMENT")) || !StringUtils.isEmpty((String)info.getExplanation()) && info.getExplanation().contains(PropertiesConstants.getValue((String)"CLAIM_PAYMENT"));
        if (isReimed) {
            type = "2";
            usage = ExplanationUtil.convertExplToBank(info.getExplanation(), info.getAmount());
        }
        JDomUtils.addChild((Element)xdataBody, (String)"payType", (String)type);
        JDomUtils.addChild((Element)xdataBody, (String)"totalRow", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)xdataBody, (String)"totalAmt", (String)bankPayRequest.getTotalAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)xdataBody, (String)"fileContent", (String)this.getCrossFileContent(paymentInfos));
        JDomUtils.addChild((Element)xdataBody, (String)"Usage", (String)usage);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private String getCrossFileContent(PaymentInfo[] infos) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < infos.length; ++i) {
            BatchCostReimbCrossImpl.app(buffer, infos[i].getIncomeAccNo());
            BatchCostReimbCrossImpl.app(buffer, infos[i].getIncomeAccName());
            BatchCostReimbCrossImpl.app(buffer, "");
            String explanation = ExplanationUtil.getExpOrAbs(infos[i]);
            BatchCostReimbCrossImpl.app(buffer, BatchCostReimbCrossImpl.formatString(explanation, 20));
            BatchCostReimbCrossImpl.app(buffer, this.getFlag(infos[i]));
            BatchCostReimbCrossImpl.app(buffer, infos[i].getIncomeCnaps());
            BatchCostReimbCrossImpl.app(buffer, infos[i].getBankDetailSeqId());
            BatchCostReimbCrossImpl.appEnd(buffer, BigDecimalHelper.plain2((BigDecimal)infos[i].getAmount()));
            if (i == infos.length - 1) continue;
            String LINE_SEP = "^";
            buffer.append(LINE_SEP);
        }
        return buffer.toString();
    }

    private static void app(StringBuilder buffer, String field) {
        String FILED_SEP = "|";
        buffer.append(BatchCostReimbCrossImpl.filter(field)).append(FILED_SEP);
    }

    private static void appEnd(StringBuilder buffer, String field) {
        buffer.append(BatchCostReimbCrossImpl.filter(field));
    }

    private static String filter(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return "";
        }
        data = StringUtils.replace((String)data, (String)"|", (String)"-");
        data = StringUtils.replace((String)data, (String)"^", (String)"-");
        return data;
    }

    private static String formatString(String string, int length) {
        if (StringUtils.isEmpty((String)string)) {
            return "";
        }
        if (string.length() > length) {
            return string.substring(0, length);
        }
        return string;
    }

    private String getFlag(PaymentInfo info) {
        BigDecimal _5W = new BigDecimal("1000000.00");
        if (BankBusinessConfig.isCyberFlag()) {
            return "11";
        }
        if (_5W.compareTo(info.getAmount()) > 0) {
            return "6";
        }
        return "7";
    }
}

