/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynhtb.dc.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynhtb.dc.utils.file.YnhtbFileUtils;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class YnhtbParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(YnhtbParser.class);

    public static boolean parseRspHead(Element rspHead) {
        String rspCode = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspCode");
        if (!"000000".equalsIgnoreCase(rspCode)) {
            String rspMsg = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspMsg");
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspCode, (String)rspMsg));
        }
        return true;
    }

    public static Element parseString2Root(String response) {
        return JDomUtils.string2Root((String)response, (String)RequestContextUtils.getCharset());
    }

    public static EBBankBalanceResponse parseBalance(BankBalanceRequest request, String rspStr) {
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomUtils.getChildElement((Element)root, (String)"RspHead") : JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        boolean success = YnhtbParser.parseRspHead(rspHead);
        if (success) {
            Element result = JDomUtils.getChildElement((Element)rspData, (String)"Result");
            BalanceInfo balanceInfo = new BalanceInfo();
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(JDomUtils.getChildTextTrim((Element)result, (String)"AcctNo"));
            bankAcnt.setAccName(JDomUtils.getChildTextTrim((Element)result, (String)"CustName"));
            bankAcnt.setCurrency(JDomUtils.getChildTextTrim((Element)result, (String)"Currency"));
            balanceInfo.setBankAcnt(bankAcnt);
            String currentBalance = JDomUtils.getChildTextTrim((Element)result, (String)"Balance");
            if (!StringUtils.isEmpty((String)currentBalance)) {
                balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimal((String)currentBalance));
            } else {
                balanceInfo.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceUtils_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
            }
            if (!StringUtils.isEmpty((String)JDomUtils.getChildTextTrim((Element)result, (String)"AvailBal"))) {
                balanceInfo.setAvailableBalance(BigDecimalHelper.str2BigDecimal((String)JDomUtils.getChildTextTrim((Element)result, (String)"AvailBal")));
            }
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public static EBBankDetailResponse parseDetail(BankDetailRequest request, String rspStr) {
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        boolean success = YnhtbParser.parseRspHead(rspHead);
        if (success) {
            Element result = JDomUtils.getChildElement((Element)rspData, (String)"Result");
            String totalNum = JDomUtils.getChildTextTrim((Element)result, (String)"TotalNum");
            String fileName = JDomUtils.getChildTextTrim((Element)result, (String)"FileName");
            String fileContent = YnhtbFileUtils.getFileFromSftp((String)fileName);
            if (StringUtils.isEmpty((String)fileContent)) {
                logger.info("\u4ece\u94f6\u884c\u83b7\u53d6\u5230\u7684\u660e\u7ec6\u6587\u4ef6:{}\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u518d\u89e3\u6790", (Object)fileName);
                return new EBBankDetailResponse(detailInfos);
            }
            String[] record = fileContent.split("\\r\\n");
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
            for (int i = 0; i < record.length; ++i) {
                DetailInfo detailInfo = new DetailInfo();
                String perRecord = record[i];
                String[] split = perRecord.split("\\|\\!", -1);
                detailInfo.setAccNo(split[0]);
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyyMMdd");
                detailInfo.setTransDate(LocalDate.parse(split[1], fmt));
                DateTimeFormatter fmt2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                String time = split[2];
                if (StringUtils.isEmpty((String)time)) {
                    detailInfo.setTransTime(LocalDateTime.parse(split[1] + "000000", fmt2));
                } else {
                    time = time.substring(0, 6);
                    detailInfo.setTransTime(LocalDateTime.parse(split[1] + time, fmt2));
                }
                String DCFlag = split[8];
                if ("0".equalsIgnoreCase(DCFlag)) {
                    detailInfo.setDebitAmount(new BigDecimal(split[3]));
                    detailInfo.setCreditAmount(new BigDecimal("0.00"));
                } else if ("1".equalsIgnoreCase(DCFlag)) {
                    detailInfo.setCreditAmount(new BigDecimal(split[3]));
                    detailInfo.setDebitAmount(new BigDecimal("0.00"));
                }
                detailInfo.setCurrency(request.getBankCurrency());
                if (StringUtils.isNotEmpty((String)split[4])) {
                    detailInfo.setBalance(new BigDecimal(split[4]));
                }
                detailInfo.setOppAccNo(split[5]);
                detailInfo.setOppAccName(split[6]);
                detailInfo.setOppBankName(split[12]);
                detailInfo.setExplanation(split[7]);
                String serialNo = split[9];
                String certNo = split[10];
                detailInfo.setPayBankDetailSeqID(certNo);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("TranDate", (Object)split[1]);
                jsonObject.put("SeqNo", (Object)serialNo);
                jsonObject.put("DCFlag", (Object)DCFlag);
                jsonObject.put("TranAmt", (Object)split[3]);
                jsonObject.put("oppAccNo", (Object)split[13]);
                detailInfo.setJsonMap(jsonObject.toJSONString());
                String accNo = request.getHeader().getAcnt().getAccNo();
                String transDate = split[1];
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonObject.toJSONString());
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
                detailInfo.setBankDetailNo(serialNo);
                detailInfos.add(detailInfo);
            }
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public static EBBankPayResponse parseSinglePay(BankPayRequest request, String rspStr) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomUtils.getChildElement((Element)root, (String)"RspHead") : JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        String rspCode = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspCode");
        if (StringUtils.isEmpty((String)rspCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62a5\u6587\u89e3\u6790\u9519\u8bef\uff0c\u6ca1\u6709rspCode\u3002", (String)"YnhtbParser_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
        }
        String rspMsg = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspMsg");
        if ("000000".equals(rspCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rspCode, (String)rspMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspCode, (String)rspMsg);
        }
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(16);
        paymentInfos.add(paymentInfo);
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseQuerySinglePay(BankPayRequest request, String rspStr) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        boolean success = YnhtbParser.parseRspHead(rspHead);
        String rspCode = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspCode");
        String rspMsg = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspMsg");
        Element result = JDomUtils.getChildElement((Element)rspData, (String)"Result");
        String tranStatus = JDomUtils.getChildTextTrim((Element)result, (String)"TranStatus");
        String tranStatusDesc = JDomUtils.getChildTextTrim((Element)result, (String)"TranStatusDesc");
        String hostSeqNo = JDomUtils.getChildTextTrim((Element)result, (String)"HostSeqNo");
        String hostDate = JDomUtils.getChildTextTrim((Element)result, (String)"HostDate");
        if ("1".equals(tranStatus) || "3".equals(tranStatus) || "5".equals(tranStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"YnhtbParser_2", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]), (String)tranStatus, (String)tranStatusDesc);
        } else if ("4".equals(tranStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"YnhtbParser_3", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]), (String)tranStatus, (String)tranStatusDesc);
        } else if ("2".equals(tranStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"YnhtbParser_4", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]), (String)tranStatus, (String)tranStatusDesc);
        }
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(16);
        paymentInfos.add(paymentInfo);
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseBatchPay(BankPayRequest request, String rspStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomUtils.getChildElement((Element)root, (String)"RspHead") : JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        String rspCode = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspCode");
        if (StringUtils.isEmpty((String)rspCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62a5\u6587\u89e3\u6790\u9519\u8bef\uff0c\u6ca1\u6709rspCode\u3002", (String)"YnhtbParser_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
        }
        String rspMsg = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspMsg");
        if ("000000".equals(rspCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rspCode, (String)rspMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspCode, (String)rspMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseQueryBatchPay(BankPayRequest request, String rspStr) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info1 = (PaymentInfo)paymentInfos.get(0);
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomUtils.getChildElement((Element)root, (String)"RspHead") : JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        String rspCode = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspCode");
        if (StringUtils.isEmpty((String)rspCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62a5\u6587\u89e3\u6790\u9519\u8bef\uff0c\u6ca1\u6709rspCode\u3002", (String)"YnhtbParser_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
        }
        String rspMsg = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspMsg");
        if (rspCode.equals("000000")) {
            Element result = JDomUtils.getChildElement((Element)rspData, (String)"Result");
            String fileName = JDomUtils.getChildTextTrim((Element)result, (String)"FileName");
            YnhtbFileUtils ynhtbFileUtils = new YnhtbFileUtils();
            String fileContent = YnhtbFileUtils.getFileFromSftp((String)fileName);
            Map payResults = ynhtbFileUtils.parseBatchPayDownloadFileContent(fileContent);
            logger.info("\u7ea2\u5854\u94f6\u884c\u72b6\u6001\u67e5\u8be2(510004)\u63a5\u53e3\u6210\u529f\u89e3\u6790\u5230{}\u6761\u4ea4\u6613\u7ed3\u679c", (Object)payResults.size());
            for (PaymentInfo paymentInfo : paymentInfos) {
                Map payResult = (Map)payResults.get(paymentInfo.getDetailSeqID());
                if (payResult == null) continue;
                String tranStatus = (String)payResult.get("TranStatus");
                String tranStatusDesc = (String)payResult.get("TranStatusDesc");
                logger.info("\u4ecemap\u4e2d\u5339\u914d\u4e0a\u4ea4\u6613\u7ed3\u679c\u8bb0\u5f55\uff0cdetailSeqID={}\uff0cstatus={}", new Object[]{paymentInfo.getDetailSeqID(), tranStatus});
                if ("1".equals(tranStatus) || "3".equals(tranStatus) || "5".equals(tranStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"YnhtbParser_2", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]), (String)tranStatus, (String)tranStatusDesc);
                    continue;
                }
                if ("4".equals(tranStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"YnhtbParser_3", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]), (String)tranStatus, (String)tranStatusDesc);
                    continue;
                }
                if (!"2".equals(tranStatus)) continue;
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"YnhtbParser_4", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]), (String)tranStatus, (String)tranStatusDesc);
            }
        } else if (rspCode.equals("999999") && !StringUtils.isEmpty((String)rspMsg) && rspMsg.contains(PropertiesConstants.getValue((String)"WAIT_AUDIT"))) {
            logger.info("\u94f6\u884c\u5f85\u5ba1\u6838\uff0c\u4e0d\u4fee\u6539\u72b6\u6001,rspCode={},rspMsg={}", new Object[]{rspCode, rspMsg});
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1a%s", (String)"YnhtbParser_5", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]), rspMsg));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static EBBankPayResponse parseSalaryPay(BankPayRequest request, String rspStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomUtils.getChildElement((Element)root, (String)"RspHead") : JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        String rspCode = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspCode");
        if (StringUtils.isEmpty((String)rspCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62a5\u6587\u89e3\u6790\u9519\u8bef\uff0c\u6ca1\u6709rspCode\u3002", (String)"YnhtbParser_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
        }
        String rspMsg = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspMsg");
        if ("000000".equals(rspCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rspCode, (String)rspMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspCode, (String)rspMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

