/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cbhb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cbhb.dc.services.Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);

    public List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return this.parseTodayDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseHeader((Element)root);
        if (!"000000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailParser_5", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{response.getResponseCode(), response.getResponseMessage()})));
        }
        Element body = root.getChild("body");
        Element transList = body.getChild("TransList");
        if (null == transList) {
            return detailList;
        }
        List records = transList.getChildren("Record");
        if (null == records || records.size() < 1) {
            return detailList;
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < records.size(); ++i) {
            try {
                Element record = (Element)records.get(i);
                String oppAcctNo = record.getChildTextTrim("OppAcctNo");
                String oppName = record.getChildTextTrim("OppName");
                String transDate = record.getChildTextTrim("TranDate");
                String amount = record.getChildTextTrim("TranAmt");
                String currency = record.getChildTextTrim("TranCcy");
                String cdFlag = record.getChildTextTrim("CDFlag");
                String remark = record.getChildTextTrim("Memo");
                String vouNo = record.getChildTextTrim("VouNo");
                String balance = record.getChildTextTrim("AcctBal");
                String serSeqNo = record.getChildTextTrim("SerSeqNo");
                String tranBrief = record.getChildTextTrim("TranBrief");
                String memoCode = record.getChildTextTrim("MemoCode");
                String oppBankName = record.getChildTextTrim("OppBankName");
                String tranTime = record.getChildTextTrim("TranTime");
                if (StringUtils.isEmpty((String)amount)) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a,Amount=%s", (String)"DetailParser_6", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]), amount));
                }
                DetailInfo detail = new DetailInfo();
                detail.setCurrency(currency);
                if ("C".equalsIgnoreCase(cdFlag)) {
                    detail.setDebitAmount(Parser.ZERO);
                    detail.setCreditAmount(new BigDecimal(amount));
                } else if ("D".equalsIgnoreCase(cdFlag)) {
                    detail.setDebitAmount(new BigDecimal(amount));
                    detail.setCreditAmount(Parser.ZERO);
                } else {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7DCFlag=%s\u3002", (String)"DetailParser_7", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]), cdFlag));
                }
                if (!StringUtils.isEmpty((String)balance)) {
                    detail.setBalance(new BigDecimal(balance));
                }
                if (!StringUtils.isEmpty((String)tranBrief) && tranBrief.contains("_KD_") && !"2014".equalsIgnoreCase(memoCode)) {
                    String payBankDetailSeqID = BizNoUtil.getId((String)tranBrief);
                    detail.setPayBankDetailSeqID(payBankDetailSeqID);
                    tranBrief = BizNoUtil.getMsg((String)tranBrief);
                }
                detail.setOppBankName(oppBankName);
                detail.setOppAccNo(oppAcctNo);
                detail.setOppAccName(oppName);
                detail.setExplanation(remark);
                if (StringUtils.isEmpty((String)transDate)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f<TransDate>\u4e3a\u7a7a\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u5904\u7406\u3002", (String)"DetailParser_3", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]));
                }
                String time = transDate;
                time = StringUtils.isNotEmpty((String)tranTime) ? time + " " + tranTime : time + " 00:00:00";
                try {
                    detail.setTransDate(LocalDateUtil.parserDate((String)transDate, (String)"yyyy-MM-dd"));
                    detail.setTransTime(LocalDateUtil.parseDateTime((String)time, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailTransDateParseErrorTips((String)time));
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
                detail.setJsonMap(jsonStr);
                detail.setBankDetailNo(serSeqNo);
                String accNo = rqst.getHeader().getAcnt().getAccNo();
                String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDateStr, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detailList.add(detail);
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u660e\u7ec6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            }
        }
        return detailList;
    }
}

