/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cbhb.dc.services.payment.company.inner;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cbhb.dc.services.CBHB_DC_Contants;
import kd.ebg.aqap.banks.cbhb.dc.services.Packer;
import kd.ebg.aqap.banks.cbhb.dc.services.Parser;
import kd.ebg.aqap.banks.cbhb.dc.services.Utils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QRTXST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u652f\u4ed8", (String)"CompanyPayQueryImpl_0", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return true;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        Element root = JDomUtils.createRoot((String)"CBHB");
        Element head = Packer.ccreateCommonHead((String)"QRTXST", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"QryBankSeqno", (String)"");
        JDomUtils.addChild((Element)body, (String)"QryClientSeqno", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)"");
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)"");
        String xmlStr = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return xmlStr;
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseHeader((Element)root);
        if (!"000000".equalsIgnoreCase(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element body = root.getChild("body");
            Element transList = body.getChild("TransList");
            if (null == transList) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de<TransList>\u8282\u70b9\u4e3a\u7a7a.", (String)"CompanyPayQueryImpl_1", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]), (String)"", (String)"");
            } else {
                List records = transList.getChildren("Record");
                if (null == records || records.size() < 1) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de<Record>\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"CompanyPayQueryImpl_2", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]), (String)"", (String)"");
                } else {
                    Element map = (Element)records.get(0);
                    String transStatus = map.getChildTextTrim("TransStatus");
                    String msg = CBHB_DC_Contants.getStatusMsg((String)transStatus);
                    if ("0".equalsIgnoreCase(transStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)transStatus, (String)msg);
                    } else if ("2".equalsIgnoreCase(transStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)transStatus, (String)msg);
                    } else if ("1".equalsIgnoreCase(transStatus) || "3".equalsIgnoreCase(transStatus) || "6".equalsIgnoreCase(transStatus) || "9".equalsIgnoreCase(transStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)transStatus, (String)msg);
                    } else {
                        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)transStatus, (String)msg);
                    }
                }
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

