/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cbhb.dc.services.payment.company.outer;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cbhb.dc.services.Packer;
import kd.ebg.aqap.banks.cbhb.dc.services.Parser;
import kd.ebg.aqap.banks.cbhb.dc.services.Utils;
import kd.ebg.aqap.banks.cbhb.dc.services.payment.company.inner.CompanyPayQueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "TXAC32";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u652f\u4ed8", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType()) && !paymentInfo.is2Individual() && !paymentInfo.is2SameBank() || "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.is2Individual() && !paymentInfo.is2SameBank() || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        Element root = JDomUtils.createRoot((String)"CBHB");
        Element head = Packer.ccreateCommonHead((String)"TXAC32", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"TransUrgency", (String)(paymentInfos[0].is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"PayAccName", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"PayAccNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"Ccy", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"Amt", (String)paymentInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"TransMemo", (String)Utils.getExplanationForSalary((PaymentInfo)paymentInfos[0]));
        JDomUtils.addChild((Element)body, (String)"RecvAccName", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"RecvAccNo", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"RecvBankName", (String)paymentInfos[0].getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"RecvBankNo", (String)paymentInfos[0].getIncomeCnaps());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseHeader((Element)root);
        if (!"000000".equalsIgnoreCase(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element body = root.getChild("body");
            String transStatus = body.getChildTextTrim("TransStatus");
            if ("0".equalsIgnoreCase(transStatus) || "9".equalsIgnoreCase(transStatus) || "H".equalsIgnoreCase(transStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)transStatus, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)transStatus, (String)"");
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

