/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hzyq.dc.service.payment.batchPay;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.HZYQ_Packer;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.TCommon;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.Utils;
import kd.ebg.aqap.banks.hzyq.dc.service.payment.batchPay.CompanyBatchPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyBatchPayQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyBatchPayQueryImpl.class);
    private static final String tradeName = "BY0003";

    public int getBatchSize() {
        return 150;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return tradeName;
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo info) {
        return info.getImplClassName().equals(CompanyBatchPayImpl.class.getName());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        Element root = new Element("body");
        Element head = HZYQ_Packer.createHZYQRoot((String)tradeName);
        JDomUtils.addChild((Element)root, (Element)head);
        Element map = new Element("map");
        JDomUtils.addChild((Element)map, (String)"erpReqNo", (String)paymentInfos[0].getBankDetailSeqId());
        JDomUtils.addChild((Element)map, (String)"billCode", (String)"");
        JDomUtils.addChild((Element)map, (String)"erpBatchNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (Element)map);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String rspmsg = HZYQ_Packer.headnumber((String)tradeName) + RspMsg;
        return TCommon.createCommonMsg((String)rspmsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = JDomUtils.getChildElement((Element)root, (String)"head");
        String erpSysCode = JDomUtils.getChildText((Element)head, (String)"erpSysCode");
        String custNo = JDomUtils.getChildText((Element)head, (String)"custNo");
        String tradeName = JDomUtils.getChildText((Element)head, (String)"tradeName");
        String retCode = JDomUtils.getChildText((Element)head, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)head, (String)"retMsg");
        if (!"0".equals(retCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56deretCode\u4e0d\u4e3a0\uff0cretMsg\u4e3a%s\u3002", (String)"CompanyBatchPayQueryImpl_12", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), retMsg);
            throw EBExceiptionUtil.payUnknownException((String)errorMsg);
        }
        Element loopData = JDomUtils.getChildElement((Element)root, (String)"loopData");
        if (null == loopData) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deloopData\u4e3a\u7a7a", (String)"CompanyBatchPayQueryImpl_14", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
        }
        List list = loopData.getChildren("row");
        for (int i = 0; i < list.size(); ++i) {
            Element row = (Element)list.get(i);
            String erpReqNo = row.getChildTextTrim("erpReqNo");
            String erpBatchNo = row.getChildTextTrim("erpBatchNo");
            String billCode = row.getChildTextTrim("billCode");
            String payeeAccNo = row.getChildTextTrim("payeeAccNo");
            String payMoney = row.getChildTextTrim("payMoney");
            String payState = row.getChildTextTrim("payState");
            String payMsg = row.getChildTextTrim("payMsg");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)erpReqNo);
            if (null == paymentInfo) continue;
            log.info("###\u672c\u6b21\u4ed8\u6b3e\u7ed3\u679c\u67e5\u8be2\u67e5\u8be2\u8fd4\u56de\u72b6\u6001" + payState);
            if ("00".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)payState, (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"CompanyBatchPayQueryImpl_2", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
                continue;
            }
            if ("01".equals(payState) || "02".equals(payState) || "03".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)payState, (String)payMsg);
                continue;
            }
            if ("98".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)payState, (String)payMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)payState, (String)payMsg);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String uri = "";
        try {
            uri = RequestContextUtils.getBankParameterValue((String)"uri");
        }
        catch (Exception e) {
            log.error("\u676d\u5dde\u94f6\u4f01\u83b7\u53d6uri\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u676d\u5dde\u8d22\u653f\u7cfb\u7edfURI\u8def\u5f84:{}", (Object)uri);
        factory.setUri(uri);
    }
}

