/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hzyq.dc.service.payment.salary;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.HZYQ_Packer;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.TCommon;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.Utils;
import kd.ebg.aqap.banks.hzyq.dc.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(SalaryPayImpl.class);
    private static final String tradeName = "BY0008";

    public int getBatchSize() {
        return 20;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return tradeName;
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equals(paymentInfo.getSubBizType()) && paymentInfo.is2Individual() || "pay".equals(paymentInfo.getSubBizType()) && HZYQ_Packer.isSalary((PaymentInfo)paymentInfo);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = new Element("body");
        Element head = HZYQ_Packer.createHZYQRoot((String)tradeName);
        JDomUtils.addChild((Element)root, (Element)head);
        Element map = new Element("map");
        PaymentInfo pay = paymentInfos[0];
        JDomUtils.addChild((Element)map, (String)"payerAccNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)map, (String)"payerCorpCode", (String)paymentInfos[0].getAccDept());
        JDomUtils.addChild((Element)map, (String)"payerCorpName", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)map, (String)"erpPayerCorpCode", (String)RequestContextUtils.getBankParameterValue((String)"erpPayerCorpCode"));
        JDomUtils.addChild((Element)map, (String)"erpBatchNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)map, (String)"erpReqUser", (String)"");
        if (ResManager.loadKDString((String)"\u5de5\u8d44", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]).equals(paymentInfos[0].getUseCn())) {
            JDomUtils.addChild((Element)map, (String)"busiType", (String)"1");
        } else {
            JDomUtils.addChild((Element)map, (String)"busiType", (String)"2");
        }
        JDomUtils.addChild((Element)map, (String)"wageTitle", (String)paymentInfos[0].getExplanation());
        JDomUtils.addChild((Element)map, (String)"totalMoney", (String)paymentInfos[0].getTotalAmount().toString());
        String t = Integer.toString(paymentInfos.length);
        JDomUtils.addChild((Element)map, (String)"totalCount", (String)t);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = paymentInfos[0].getRequestTime().atZone(zoneId);
        JDomUtils.addChild((Element)map, (String)"wishPayday", (String)HZYQ_Packer.formateY2SDate((Date)Date.from(zdt.toInstant())));
        JDomUtils.addChild((Element)map, (String)"isErpCode", (String)"0");
        JDomUtils.addChild((Element)map, (String)"payFlow", (String)"2");
        JDomUtils.addChild((Element)root, (Element)map);
        Element loopData = new Element("loopData");
        JDomUtils.addChild((Element)root, (Element)loopData);
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element row = JDomUtils.addChild((Element)loopData, (String)"row");
            JDomUtils.addChild((Element)row, (String)"empNo", (String)paymentInfos[i].getBankSerialNo());
            JDomUtils.addChild((Element)row, (String)"userName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"bankAcc", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"payeeBankName", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)row, (String)"amt", (String)paymentInfos[i].getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"purpose", (String)paymentInfos[i].getUseCn());
            JDomUtils.addChild((Element)row, (String)"rmk", (String)paymentInfos[i].getExplanation());
            JDomUtils.addChild((Element)row, (String)"difBank", (String)"");
            JDomUtils.addChild((Element)row, (String)"payeeBankCode", (String)paymentInfos[i].getIncomeCnaps());
        }
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String rspmsg = HZYQ_Packer.headnumber((String)tradeName) + RspMsg;
        return TCommon.createCommonMsg((String)rspmsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = JDomUtils.getChildElement((Element)root, (String)"head");
        String erpSysCode = JDomUtils.getChildText((Element)head, (String)"erpSysCode");
        String custNo = JDomUtils.getChildText((Element)head, (String)"custNo");
        String tradeName = JDomUtils.getChildText((Element)head, (String)"tradeName");
        String retCode = JDomUtils.getChildText((Element)head, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)head, (String)"retMsg");
        Element map = root.getChild("map");
        String wageNo = JDomUtils.getChildText((Element)map, (String)"wageNo");
        if ("0".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"SalaryPayImpl_1", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        } else if ("2".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryPayImpl_2", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        } else if ("9".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u901a\u8baf\u8d85\u65f6\u6216\u5f02\u5e38\u3002", (String)"SalaryPayImpl_3", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u5176\u4ed6\u72b6\u6001", (String)"SalaryPayImpl_4", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String uri = "";
        try {
            uri = RequestContextUtils.getBankParameterValue((String)"uri");
        }
        catch (Exception e) {
            log.error("\u676d\u5dde\u94f6\u4f01\u83b7\u53d6uri\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u676d\u5dde\u8d22\u653f\u7cfb\u7edfURI\u8def\u5f84:{}", (Object)uri);
        factory.setUri(uri);
    }
}

