/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hzyq.dc.service.payment.salary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.HZYQ_Packer;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.TCommon;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.Utils;
import kd.ebg.aqap.banks.hzyq.dc.service.payment.salary.SalaryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);
    private static final String tradeName = "BY0009";

    public int getBatchSize() {
        return 20;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return tradeName;
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo info) {
        return info.getImplClassName().equals(SalaryPayImpl.class.getName());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray((List)request.getPaymentInfos());
        Element root = new Element("body");
        Element head = HZYQ_Packer.createHZYQRoot((String)tradeName);
        JDomUtils.addChild((Element)root, (Element)head);
        Element map = new Element("map");
        JDomUtils.addChild((Element)map, (String)"wageNo", (String)"");
        JDomUtils.addChild((Element)map, (String)"erpBatchNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (Element)map);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String rspmsg = HZYQ_Packer.headnumber((String)tradeName) + RspMsg;
        return TCommon.createCommonMsg((String)rspmsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        List<PaymentInfo> paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = JDomUtils.getChildElement((Element)root, (String)"head");
        String erpSysCode = JDomUtils.getChildText((Element)head, (String)"erpSysCode");
        String custNo = JDomUtils.getChildText((Element)head, (String)"custNo");
        String tradeName = JDomUtils.getChildText((Element)head, (String)"tradeName");
        String retCode = JDomUtils.getChildText((Element)head, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)head, (String)"retMsg");
        if (!"0".equals(retCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ee3\u53d1\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"SalaryQueryPayImpl_14", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), retMsg);
            throw EBExceiptionUtil.payUnknownException((String)errorMsg);
        }
        Element map = JDomUtils.getChildElement((Element)root, (String)"map");
        String recordTotal = JDomUtils.getChildText((Element)map, (String)"recordTotal");
        String batchState = JDomUtils.getChildText((Element)map, (String)"batchState");
        if ("01".equals(batchState) || "02".equals(batchState) || "03".equals(batchState)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)batchState, (String)"");
        } else if ("00".equals(batchState) || "98".equals(batchState)) {
            Element loopData = JDomUtils.getChildElement((Element)root, (String)"loopData");
            if (loopData == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684xml\u9519\u8bef\uff0cloopData\u8282\u70b9\u4e0d\u5b58\u5728\u3002", (String)"SalaryQueryPayImpl_11", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
            }
            paymentInfos = this.preBatchSameItemCheck(request);
            List list = loopData.getChildren("row");
            for (int i = 0; i < list.size(); ++i) {
                Element row = (Element)list.get(i);
                String bankAcc = row.getChildTextTrim("bankAcc");
                String amt = row.getChildTextTrim("amt");
                BigDecimal amount = new BigDecimal(amt.trim());
                amount = amount.setScale(2);
                String payState = row.getChildTextTrim("payState");
                String payMsg = row.getChildTextTrim("payMsg");
                PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)bankAcc, (BigDecimal)amount);
                if (null == paymentInfo) continue;
                this.handlePayStatus(paymentInfo, payState, payMsg);
            }
            this.processingBankItemDataHandler(list);
            PayStatusMatchUtil.backBatchSameItemHandler((List)request.getPaymentInfos(), (boolean)false, (boolean)false);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)batchState, (String)"");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    public void processingBankItemDataHandler(List<Element> elementList) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = this.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String payState = element.getChildTextTrim("payState");
                    String payMsg = element.getChildTextTrim("payMsg");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, payState, payMsg);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public PaymentInfo handlePayStatus(PaymentInfo tempInfo, String payState, String payMsg) {
        if ("0".equals(payState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)payState, (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
        } else if ("2".equals(payState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)payState, (String)payMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)payState, (String)payMsg);
        }
        return tempInfo;
    }

    private String getBankDataKey(Element element) {
        String incomeNo = element.getChildText("bankAcc");
        String incomeName = element.getChildText("userName");
        String amount = element.getChildText("amt");
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(incomeNo).append(incomeName).append(new BigDecimal(amount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String uri = "";
        try {
            uri = RequestContextUtils.getBankParameterValue((String)"uri");
        }
        catch (Exception e) {
            log.error("\u676d\u5dde\u94f6\u4f01\u83b7\u53d6uri\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u676d\u5dde\u8d22\u653f\u7cfb\u7edfURI\u8def\u5f84:{}", (Object)uri);
        factory.setUri(uri);
    }
}

