/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jnb.dc.service.payment.company;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jnb.dc.service.Packer;
import kd.ebg.aqap.banks.jnb.dc.service.payment.company.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "B2EBatchTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8", (String)"PayImpl_0", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ((PayTypeEnum.PAY_FOR_CAPITAL_ALLOCATION.getName().equalsIgnoreCase(paymentInfo.getSubBizType()) || UseConvertor.isTransfer((PaymentInfo)paymentInfo)) && !paymentInfo.is2SameBank()) {
            return true;
        }
        return true;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TransCode", (String)"B2EBatchTransfer");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)LocalDateTime.now().format(Packer.DATE_TIME_SEPARATION_FORMATTER));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)request.getBankBatchSeqID());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element map = JDomUtils.addChild((Element)list, (String)"Map");
            JDomUtils.addChild((Element)map, (String)"TransferType", (String)(paymentInfos[i].is2SameBank() ? "001" : "002"));
            JDomUtils.addChild((Element)map, (String)"TransferJnlNo", (String)paymentInfos[i].getBankDetailSeqId());
            JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)paymentInfos[i].getAccName());
            JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)paymentInfos[i].getAccNo());
            JDomUtils.addChild((Element)map, (String)"PayerCurrency", (String)paymentInfos[i].getCurrency());
            JDomUtils.addChild((Element)map, (String)"PayerBankAcType", (String)"");
            JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"PayeeBankAcType", (String)"");
            JDomUtils.addChild((Element)map, (String)"Amount", (String)paymentInfos[i].getAmount().toString());
            JDomUtils.addChild((Element)map, (String)"UnionDeptId", (String)paymentInfos[i].getIncomeCnaps());
            BigDecimal five_wang = new BigDecimal("50000.00");
            if (paymentInfos[i].getAmount().compareTo(five_wang) > 0) {
                JDomUtils.addChild((Element)map, (String)"Priority", (String)"1");
            } else {
                JDomUtils.addChild((Element)map, (String)"Priority", (String)(paymentInfos[i].is2Merge() ? "1" : "0"));
            }
            JDomUtils.addChild((Element)map, (String)"Remark", (String)paymentInfos[i].getExplanation());
        }
        return JDomUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element error = root.getChild("error");
        if (null != error) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)error.getTextTrim());
            return new EBBankPayResponse(paymentInfos);
        }
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        if (!"000000".equals(iBSReturnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)iBSReturnCode, (String)iBSReturnMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        if (null == list || list.getChildren() == null || list.getChildren().size() < 1) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"PayImpl_1", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        List maps = list.getChildren();
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String returnCode = map.getChildTextTrim("ReturnCode");
            String returnMsg = map.getChildTextTrim("ReturnMsg");
            String transferJnlNo = map.getChildTextTrim("TransferJnlNo");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)transferJnlNo);
            if (null == paymentInfo) continue;
            if ("000000".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"PayImpl_3", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)returnCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PayImpl_4", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("000002".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"PayImpl_3", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayImpl_5", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append("B2EBatchTransfer").append(".do").append("?").append("userPassword=").append(RequestContextUtils.getBankParameterValue((String)"userPassword")).append("&SIGDATA=1");
        factory.setUri(sb.toString());
    }
}

