/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbcmys.dc.service.payment;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbcmys.dc.BankBusinessConfig;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HSBCMYS_DC_CommonPacker {
    public static Element packPayXmlhead(List<PaymentInfo> paymentInfos, Element CstmrCdtTrfInitn, String connectCustomerID) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element GrpHdr = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"GrpHdr").setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"MsgId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"CreDtTm", (String)LocalDateTime.now().toString()).setNamespace(ns1);
        String payProtocol = BankBusinessConfig.getPayProtocol();
        if (!StringUtils.isEmpty((String)payProtocol)) {
            Element Authstn = JDomUtils.addChild((Element)GrpHdr, (String)"Authstn").setNamespace(ns1);
            JDomUtils.addChild((Element)Authstn, (String)"Cd", (String)payProtocol).setNamespace(ns1);
        }
        Element NbOfTxs = JDomUtils.addChild((Element)GrpHdr, (String)"NbOfTxs").setNamespace(ns1);
        NbOfTxs.addContent(String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)GrpHdr, (String)"CtrlSum").setNamespace(ns1);
        Element InitgPty = JDomUtils.addChild((Element)GrpHdr, (String)"InitgPty").setNamespace(ns1);
        Element Id = JDomUtils.addChild((Element)InitgPty, (String)"Id").setNamespace(ns1);
        Element OrgId = JDomUtils.addChild((Element)Id, (String)"OrgId").setNamespace(ns1);
        Element Othr = JDomUtils.addChild((Element)OrgId, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)Othr, (String)"Id", (String)connectCustomerID).setNamespace(ns1);
        return GrpHdr;
    }

    public static Element packPayXmlPmtInfo(List<PaymentInfo> paymentInfos, Element CstmrCdtTrfInitn) {
        List<String> membids;
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String serviceLevel = paymentInfo.getServiceLevel();
        String pmtMtd = paymentInfo.getPaymentMethod();
        String accNo = paymentInfo.getAccNo();
        String checkUsage = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"chequeUsage");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element PmtInf = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"PmtInf").setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtInfId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtMtd", (String)pmtMtd).setNamespace(ns1);
        Element PmtTpInf = JDomUtils.addChild((Element)PmtInf, (String)"PmtTpInf").setNamespace(ns1);
        if ("CHK".equalsIgnoreCase(pmtMtd)) {
            Element LclInstrm = JDomUtils.addChild((Element)PmtTpInf, (String)"LclInstrm").setNamespace(ns1);
            JDomUtils.addChild((Element)LclInstrm, (String)"Prtry", (String)checkUsage).setNamespace(ns1);
        } else {
            Element SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns1);
            JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)serviceLevel).setNamespace(ns1);
        }
        LocalDateTime bookingTime = paymentInfo.getBookingTime();
        if (bookingTime == null) {
            bookingTime = LocalDateTime.now();
        }
        JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)bookingTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).setNamespace(ns1);
        PaymentUtil.setBookPayFlag(paymentInfos);
        Element Dbtr = JDomUtils.addChild((Element)PmtInf, (String)"Dbtr").setNamespace(ns1);
        JDomUtils.addChild((Element)Dbtr, (String)"Nm", (String)BankBusinessConfig.getCompany(accNo)).setNamespace(ns1);
        Element PstlAdr = JDomUtils.addChild((Element)Dbtr, (String)"PstlAdr").setNamespace(ns1);
        kd.ebg.aqap.banks.hsbc.dc.utils.PaymentUtil.addressSplit((Element)PstlAdr, (String)BankBusinessConfig.getStreet(accNo));
        JDomUtils.addChild((Element)PstlAdr, (String)"Ctry", (String)BankBusinessConfig.getCountry(accNo)).setNamespace(ns1);
        if (!"TRF".equalsIgnoreCase(pmtMtd) || !"NURG".equalsIgnoreCase(serviceLevel) || (membids = BankBusinessConfig.getDBRTID(accNo)) == null || membids.size() > 0) {
            // empty if block
        }
        Element DbtrAcct = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAcct").setNamespace(ns1);
        Element DbtrAcct_Id = JDomUtils.addChild((Element)DbtrAcct, (String)"Id").setNamespace(ns1);
        if ("HSBCUK_DC".equalsIgnoreCase(paymentInfo.getBankVersionID()) && ("NURG".equalsIgnoreCase(paymentInfo.getServiceLevel()) || "URGP".equalsIgnoreCase(paymentInfo.getServiceLevel()))) {
            JDomUtils.addChild((Element)DbtrAcct_Id, (String)"IBAN", (String)paymentInfo.getIncomeAccNo()).setNamespace(ns1);
        } else {
            Element DbtrAcct_Othr = JDomUtils.addChild((Element)DbtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)DbtrAcct_Othr, (String)"Id", (String)accNo).setNamespace(ns1);
        }
        JDomUtils.addChild((Element)DbtrAcct, (String)"Ccy", (String)paymentInfo.getCurrency()).setNamespace(ns1);
        Element DbtrAgt = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAgt").setNamespace(ns1);
        Element FinInstnId = JDomUtils.addChild((Element)DbtrAgt, (String)"FinInstnId").setNamespace(ns1);
        String bic = BankBusinessConfig.getBicCode(accNo);
        if (StringUtils.isEmpty((String)bic)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u7684BIC swift code\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728[\u94f6\u4f01\u8d26\u6237]\u9875\u9762\u7ef4\u62a4", (String)"HSBCMYS_DC_CommonPacker_0", (String)"ebg-aqap-banks-hsbcmys-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)bic).setNamespace(ns1);
        String name = BankBusinessConfig.getBankName(accNo);
        if (StringUtils.isEmpty((String)name)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728[\u94f6\u4f01\u8d26\u6237]\u9875\u9762\u7ef4\u62a4\u3002", (String)"HSBCMYS_DC_CommonPacker_1", (String)"ebg-aqap-banks-hsbcmys-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)FinInstnId, (String)"Nm", (String)name).setNamespace(ns1);
        Element FinInstnId_PstlAdr = JDomUtils.addChild((Element)FinInstnId, (String)"PstlAdr").setNamespace(ns1);
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getAccCountry());
        if (code == null) {
            code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getAccCountry());
        }
        JDomUtils.addChild((Element)FinInstnId_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
        return PmtInf;
    }
}

