/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.dc.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bbgb.dc.BBGBMetaDataImpl;
import kd.ebg.aqap.banks.bbgb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.bbgb.dc.services.utils.SecurityUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ebank-customer/accountDetailQuery/accountTranHistQuery.do");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String currentPage = this.getCurrentPage();
        String jsonString = Packer.packDetail((BankDetailRequest)bankDetailRequest, (String)currentPage).toJSONString();
        String sign = SecurityUtil.getInstance().getSign(jsonString);
        String encry = SecurityUtil.getInstance().getEncry(jsonString);
        JSONObject detail = new JSONObject();
        detail.put("signData", (Object)sign);
        detail.put("ciphertext", (Object)encry);
        detail.put("bankCertSN", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.bankPublicSN));
        return detail.toJSONString();
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String currentPage = this.getCurrentPage();
        int nextPage = Integer.parseInt(currentPage) + 100;
        this.setCurrentPage(String.valueOf(nextPage));
        JSONObject response = JSONObject.parseObject((String)s);
        String sys_code = response.getString("sys_code");
        String sys_msg = response.getString("sys_msg");
        if (!"0".equalsIgnoreCase(sys_code)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), sys_code, sys_msg));
        }
        String data = response.getString("data");
        String decry = SecurityUtil.getInstance().getDecry(data);
        JSONObject detailJson = JSONObject.parseObject((String)decry);
        String ec = detailJson.getString("ec");
        String em = detailJson.getString("em");
        if (!"0".equalsIgnoreCase(ec)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), ec, em));
        }
        JSONObject details = detailJson.getJSONObject("data");
        String turnPageTotalNum = details.getString("turnPageTotalNum");
        if (nextPage >= Integer.parseInt(turnPageTotalNum)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
        }
        JSONArray jsonArray = details.getJSONArray("iTranHistInfoCopy");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int j = 0; j < jsonArray.size(); ++j) {
            JSONObject detail = jsonArray.getJSONObject(j);
            String tranDate = detail.getString("tranDate");
            String currencyType = detail.getString("currencyType");
            String loanFlag = detail.getString("loanFlag");
            String tranAmt = detail.getString("tranAmt");
            String actualBalAmt = detail.getString("actualBalAmt");
            String othBankName = detail.getString("othBankName");
            String othBankCode = detail.getString("othBankCode");
            String othBaseAcctNo = detail.getString("othBaseAcctNo");
            String othAcctDesc = detail.getString("othAcctDesc");
            String narrative = detail.getString("narrative");
            String tranNote = detail.getString("tranNote");
            String tranTimestamp = detail.getString("tranTimestamp");
            DetailInfo info = new DetailInfo();
            info.setAccNo(acnt.getAccNo());
            info.setAccName(acnt.getAccName());
            info.setBankName(acnt.getBankName());
            info.setTransDate(LocalDate.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            info.setTransTime(LocalDateTime.parse(tranTimestamp, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            info.setCurrency(currencyType);
            if (!StringUtils.isEmpty((String)actualBalAmt)) {
                info.setBalance(new BigDecimal(actualBalAmt));
            }
            if ("C".equalsIgnoreCase(loanFlag)) {
                info.setCreditAmount(new BigDecimal(tranAmt));
                info.setDebitAmount(BigDecimal.ZERO);
            } else if ("D".equalsIgnoreCase(loanFlag)) {
                info.setDebitAmount(new BigDecimal(tranAmt));
                info.setCreditAmount(BigDecimal.ZERO);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u501f\u8d37\u6807\u8bc6:%1$s\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), loanFlag));
            }
            if (!StringUtils.isEmpty((String)tranNote) && tranNote.contains("_KD_")) {
                info.setPayBankDetailSeqID(BizNoUtil.getId((String)tranNote));
            }
            info.setOppAccNo(othBaseAcctNo);
            info.setOppAccName(othAcctDesc);
            info.setOppBankName(othBankName);
            info.setExplanation(tranNote);
            info.setJsonMap(detail.toJSONString());
            String transDateStr = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transDateStr, detail.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            info.setReceiptNo(receiptNo);
            detailList.add(info);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean isSupportPage() {
        return true;
    }
}

