/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzccb.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.RequestPacker;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.ResponseParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyQueryPayDetailImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final Logger logger = LoggerFactory.getLogger(CompanyQueryPayDetailImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return this.packQueryPayDetail();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        this.parseQueryPayDetail(bankPayRequest.getPaymentInfoAsArray(), res);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200202";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u660e\u7ec6\u7ed3\u679c\u67e5\u8be2", (String)"CompanyQueryPayDetailImpl_18", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]);
    }

    public String packQueryPayDetail() {
        try {
            Element head = RequestPacker.getHeadPackerData((String)"200202", (String)"0", (String)Sequence.genSequence());
            Element body = RequestPacker.getQueryPayBodyDetail();
            String requestStr = RequestPacker.getRequest((Element)head, (Element)body);
            return requestStr;
        }
        catch (Exception var) {
            logger.error("======\u8f6c\u8d26\u660e\u7ec6\u67e5\u8be2\u8bf7\u6c42\u62a5\u6587\u62fc\u63a5\u5f02\u5e38======" + var.getMessage());
            throw new EBServiceException((Throwable)var);
        }
    }

    public void parseQueryPayDetail(PaymentInfo[] paymentInfos, String response) {
        try {
            Element element = CommonUtil.getResponseElement(response);
            Element head = element.getChild("head");
            Element body = element.getChild("body");
            BankResponse headRsp = CommonUtil.parseBankResponse(head);
            String bankStatus = headRsp.getResponseCode();
            if (!"0_0000".equals(bankStatus)) {
                logger.info("===\u5f53\u524d\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u5931\u8d25===");
                throw EBExceiptionUtil.serviceException((String)headRsp.getResponseMessage());
            }
            String recordNumStr = body.getChildTextTrim("record_num");
            String fieldNumStr = body.getChildTextTrim("field_num");
            String fileFlag = head.getChildTextTrim("file_flag");
            if (StringUtils.isEmpty((String)fieldNumStr) || StringUtils.isEmpty((String)recordNumStr)) {
                logger.info("===\u672c\u6b21\u5355\u7b14\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a===");
                EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u6b21\u5355\u7b14\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"CompanyQueryPayDetailImpl_3", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]));
            }
            int fieldNum = Integer.parseInt(fieldNumStr);
            int recordNum = Integer.parseInt(recordNumStr);
            if (fieldNum <= 0 || recordNum <= 0) {
                logger.info("===\u672c\u6b21\u5355\u7b14\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a===");
                EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u6b21\u5355\u7b14\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"CompanyQueryPayDetailImpl_3", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]));
            }
            String content = ResponseParser.resContentHandle((Element)body, (String)fileFlag);
            String[][] rs = ResponseParser.parseContent((String)content, (int)recordNum, (int)fieldNum);
            CompanyQueryPayDetailImpl.parsepayInfo(paymentInfos, rs);
        }
        catch (Exception var) {
            logger.error("====\u652f\u4ed8\u8f6c\u8d26\u660e\u7ec6\u67e5\u8be2\u89e3\u6790\u9519\u8bef===" + var.getMessage());
            throw new EBServiceException((Throwable)var);
        }
    }

    private static void parsepayInfo(PaymentInfo[] paymentInfos, String[][] rs) {
        for (int i = 0; i < rs.length; ++i) {
            String certNo = rs[i][4];
            String accnbr = rs[i][13];
            String trsamt = rs[i][19];
            String TransStatus = rs[i][25];
            String bankErrorInfo = rs[i][26];
            if (StringUtils.isEmpty((String)trsamt)) {
                throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u91d1\u989dTRSAMT \u4e3a\u7a7a", (String)"CompanyQueryPayDetailImpl_2", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]));
            }
            logger.info("c\uff1a(" + trsamt + ")\u6253\u5370\u6536\u6b3e\u91d1\u989d\uff1a(" + accnbr + ")\u6253\u5370\u72b6\u6001\uff1a(" + TransStatus + ")");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)certNo);
            if (paymentInfo == null) continue;
            if ("9".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)TransStatus, (String)bankErrorInfo);
                continue;
            }
            if ("1".equals(TransStatus) || "6".equals(TransStatus) || "7".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)TransStatus, (String)bankErrorInfo);
                continue;
            }
            if ("3".equals(TransStatus) || "8".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)TransStatus, (String)bankErrorInfo);
                continue;
            }
            if ("2".equals(TransStatus) || "5".equals(TransStatus) || "0".equals(TransStatus) || "A".equals(TransStatus) || "B".equals(TransStatus) || "C".equals(TransStatus) || "D".equals(TransStatus) || "E".equals(TransStatus) || "L".equals(TransStatus) || "4".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)TransStatus, (String)bankErrorInfo);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)TransStatus, (String)"");
        }
    }
}

