/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBPacker;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBStringUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final String FORMAT = "yyyyMMdd";

    public String pack(BankDetailRequest request) {
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage)) {
            this.setCurrentPage(1);
        }
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData((String)this.getBizCode()));
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"accountNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern(FORMAT)));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern(FORMAT)));
        JDomUtils.addChild((Element)body, (String)"turnPageNum", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"turnPageShowNum", (String)"20");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign((String)reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ebank>" + GLBStringUtils.replaceBlank((String)reqstMsg) + GLBStringUtils.replaceBlank((String)sign) + "</ebank>";
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        Element listElement;
        List list;
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ebenk.getChild("head");
        if (!"000000".equals(head.getChildTextTrim("retCode"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), head.getChildText("retMessage"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = ebenk.getChild("body");
        String turnPageTotalNum = body.getChildText("turnPageTotalNum");
        if (this.lastPage(turnPageTotalNum)) {
            this.setLastPage(true);
        }
        if ((list = (listElement = body.getChild("list")).getChildren("row")).isEmpty()) {
            return new EBBankDetailResponse();
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < list.size(); ++i) {
            DetailInfo detail = new DetailInfo();
            Element row = (Element)list.get(i);
            String currency = row.getChildText("currencyType");
            detail.setCurrency(currency);
            String acctNo = row.getChildTextTrim("acctNo");
            String accountName = row.getChildTextTrim("accountName");
            String accountOpenNode = row.getChildTextTrim("accountOpenNode");
            detail.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detail.setOppAccNo(acctNo);
            detail.setOppAccName(accountName);
            detail.setOppBankName(accountOpenNode);
            String transferDate = row.getChildTextTrim("transferTime");
            LocalDateTime localDateTime = LocalDateTime.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss"));
            detail.setTransTime(localDateTime);
            detail.setTransDate(localDateTime.toLocalDate());
            String payAmount = row.getChildTextTrim("payAmount");
            String recAmount = row.getChildTextTrim("recAmount");
            if (StringUtils.isEmpty((String)payAmount) && StringUtils.isEmpty((String)recAmount)) {
                logger.error("\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5f02\u5e38\uff0c\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u540c\u65f6\u4e3a\u7a7a\u3002");
                continue;
            }
            if (StringUtils.isEmpty((String)payAmount)) {
                payAmount = "0.00";
            } else if (StringUtils.isEmpty((String)recAmount)) {
                recAmount = "0.00";
            }
            detail.setDebitAmount(new BigDecimal(payAmount));
            detail.setCreditAmount(new BigDecimal(recAmount));
            String balance = row.getChildTextTrim("balance");
            if (StringUtils.isNotEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            String summary = row.getChildTextTrim("summary");
            detail.setExplanation(summary);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(row.getChildTextTrim("hostFlowNo"));
            String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transDateStr, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE010201";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    private boolean lastPage(String turnPageTotalNum) {
        int totalPage = Integer.parseInt(turnPageTotalNum);
        if (totalPage <= 20) {
            return true;
        }
        int currentPage = Integer.parseInt(this.getCurrentPage()) * 20;
        if (currentPage <= totalPage) {
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
            return false;
        }
        return true;
    }

    public boolean isSupportPage() {
        return true;
    }
}

