/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.ccip.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.ccip.common.CDBBankResponse;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonPacker;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonParser;
import kd.ebg.aqap.banks.cdb.ccip.helper.LoginUtils;
import kd.ebg.aqap.banks.cdb.ccip.util.JDomExtUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public String pack(BankDetailRequest bankDetailRequest) {
        LoginUtils.getInstance().doBiz();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader((String)"P1CMSER65", (String)Sequence.genSequence(), (String)"", (String)(this.getCurrentPage().equalsIgnoreCase("0") ? "1" : this.getCurrentPage()));
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity((String)"O0220001", (String)Sequence.genSequence());
        body.addContent((Content)request);
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData((Element)list1, (String)"AccNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomExtUtils.addChildCDData((Element)request, (String)"StDt", (String)bankDetailRequest.getStartDate().format(this.dateFormatter));
        JDomExtUtils.addChildCDData((Element)request, (String)"EdDt", (String)bankDetailRequest.getEndDate().format(this.dateFormatter));
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        rspStr = CommonParser.preParse((String)rspStr);
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element transaction_header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String TOTAL_PAGE = transaction_header.getChildTextTrim("TOTAL_PAGE");
        int total_page = Integer.parseInt(TOTAL_PAGE);
        int page = Integer.parseInt(this.getCurrentPage().equalsIgnoreCase("0") ? "1" : this.getCurrentPage());
        if (page >= total_page) {
            this.setCurrentPage(page + 1);
            this.setLastPage(true);
        } else {
            this.setCurrentPage(page + 1);
            this.setLastPage(false);
        }
        CDBBankResponse bankResp = CommonParser.getBankPreResponse((String)rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%1$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(16);
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String rcrdNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        List detaiList = response.getChildren("LIST1");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!"0".equals(rcrdNum)) {
            for (Element node : detaiList) {
                String cramount;
                DetailInfo info = new DetailInfo();
                String CstPty_Py_Jrnl_No = JDomExtUtils.getChildText((Element)node, (String)"CstPty_Py_Jrnl_No");
                if (!StrUtil.isEmpty((String)CstPty_Py_Jrnl_No) && CstPty_Py_Jrnl_No.indexOf("KD_") != -1) {
                    String KDDetailNo = CstPty_Py_Jrnl_No.substring(CstPty_Py_Jrnl_No.indexOf("KD_") + "KD_".length());
                    info.setKdFlag(KDDetailNo);
                    info.setPayBankDetailSeqID(KDDetailNo);
                }
                String txDt = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dt");
                String txTm = JDomExtUtils.getChildText((Element)node, (String)"Txn_Tm");
                String detailNo = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dtl_No");
                String Bnk_Only1_ID_ID = JDomExtUtils.getChildText((Element)node, (String)"Bnk_Only1_ID_ID");
                String stDt = JDomExtUtils.getChildText((Element)node, (String)"Stm_Dt");
                if (StringUtils.isEmpty((String)txTm)) {
                    txTm = "000000";
                }
                txTm = txDt + txTm;
                try {
                    info.setTransDate(LocalDate.parse(txDt, this.dateFormatter));
                    info.setTransTime(LocalDateTime.parse(txTm, this.dateTimeFormatter));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u4ea4\u6613\u65f6\u95f4\u51fa\u9519\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]), (Throwable)e);
                }
                String amount = "e";
                String dhamount = JDomExtUtils.getChildText((Element)node, (String)"DHAmt");
                if (!StringUtils.isEmpty((String)dhamount)) {
                    info.setDebitAmount(new BigDecimal(dhamount));
                    if (info.getDebitAmount().compareTo(BigDecimal.ZERO) > 0) {
                        amount = dhamount;
                    }
                }
                if (!StringUtils.isEmpty((String)(cramount = JDomExtUtils.getChildText((Element)node, (String)"Cr_HpnAm")))) {
                    info.setCreditAmount(new BigDecimal(cramount));
                    if (info.getCreditAmount().compareTo(BigDecimal.ZERO) > 0) {
                        amount = cramount;
                    }
                }
                info.setAccNo(bankDetailRequest.getAcnt().getAccNo());
                info.setAccName(bankDetailRequest.getAcnt().getAccName());
                String currency = JDomExtUtils.getChildText((Element)node, (String)"CcyCd");
                info.setCurrency(currency);
                String orAccNo = JDomExtUtils.getChildText((Element)node, (String)"CntprtAcc");
                info.setOppAccNo(orAccNo);
                String orAccName = JDomExtUtils.getChildText((Element)node, (String)"Cntrprt_AccNm");
                info.setOppAccName(orAccName);
                String cdbankNm = JDomExtUtils.getChildText((Element)node, (String)"CDBank_Nm");
                if (StringUtils.isEmpty((String)cdbankNm)) {
                    cdbankNm = JDomExtUtils.getChildText((Element)node, (String)"CADBank_Nm");
                }
                if (!StringUtils.isEmpty((String)cdbankNm)) {
                    info.setOppBankName(cdbankNm);
                }
                String Smy = JDomExtUtils.getChildText((Element)node, (String)"Smy");
                String remark = JDomExtUtils.getChildText((Element)node, (String)"Rmrk");
                if (StringUtils.isEmpty((String)remark)) {
                    info.setExplanation(Smy);
                } else {
                    info.setExplanation(remark);
                }
                if (!"caizi".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)bankDetailRequest.getAcnt().getAccNo()))) {
                    String bal = JDomExtUtils.getChildText((Element)node, (String)"AcBa");
                    if (StringUtils.isEmpty((String)bal)) {
                        bal = JDomExtUtils.getChildText((Element)node, (String)"Bal");
                    }
                    if (!StringUtils.isEmpty((String)bal)) {
                        info.setBalance(new BigDecimal(bal));
                    }
                } else {
                    String CshPl_Bal = JDomExtUtils.getChildText((Element)node, (String)"CshPl_Bal");
                    if (!StringUtils.isEmpty((String)CshPl_Bal)) {
                        info.setBalance(new BigDecimal(CshPl_Bal));
                    }
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(node);
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("Amount", (Object)amount);
                String transDateStr = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transDateStr, jsonObject.toJSONString());
                info.setJsonMap(jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                info.setReceiptNo(receiptNo);
                detailInfoList.add(info);
            }
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSER65";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

