/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.ccip.services.payment;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.ccip.BankBusinessConfig;
import kd.ebg.aqap.banks.cdb.ccip.common.CommonPacker;
import kd.ebg.aqap.banks.cdb.ccip.helper.LoginUtils;
import kd.ebg.aqap.banks.cdb.ccip.services.payment.CZQueryPaymentImpl;
import kd.ebg.aqap.banks.cdb.ccip.services.payment.PaymentImpl;
import kd.ebg.aqap.banks.cdb.ccip.util.JDomExtUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class CZPaymentImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CZPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CZQueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        LoginUtils.getInstance().doBiz();
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader((String)"P1G015011", (String)Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity((String)"O0120002", (String)paymentInfo.getBankBatchSeqId());
        body.addContent((Content)request);
        String cstid = RequestContextUtils.getBankParameterValue((String)"cstid");
        JDomExtUtils.addChildCDData((Element)request, (String)"Cst_ID", (String)cstid);
        JDomExtUtils.addChildCDData((Element)request, (String)"SdSMS_Ind", (String)"0");
        JDomExtUtils.addChildCDData((Element)request, (String)"Cst_Nm", (String)paymentInfo.getAccName());
        JDomExtUtils.addChildCDData((Element)request, (String)"Pcs_Tp_ID", (String)"00");
        JDomExtUtils.addChildCDData((Element)request, (String)"WF_FCN_ID", (String)"G0010000");
        JDomExtUtils.addChildCDData((Element)request, (String)"BIZ_SUB_FCN_ID", (String)"G0010002");
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomExtUtils.addChildCDData((Element)request, (String)"Pcs_StTm", (String)date);
        JDomExtUtils.addChildCDData((Element)request, (String)"EBnk_SvAr_ID", (String)RequestContextUtils.getBankParameterValue((String)"CoustomerNo"));
        JDomExtUtils.addChildCDData((Element)request, (String)"TDP_ID", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
        JDomExtUtils.addChildCDData((Element)request, (String)"TDP_Nm", (String)RequestContextUtils.getBankParameterValue((String)"cusname"));
        JDomExtUtils.addChildCDData((Element)request, (String)"Mgr_Ind", (String)"0");
        JDomExtUtils.addChildCDData((Element)request, (String)"AccNo", (String)paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData((Element)request, (String)"CcyCd", (String)paymentInfo.getCurrency());
        JDomExtUtils.addChildCDData((Element)request, (String)"Rqs_Amt", (String)paymentInfo.getAmount().toString());
        JDomExtUtils.addChildCDData((Element)request, (String)"P_TPL_NO", (String)"00000000000000000000000000000000000000000000000000");
        Element BsnInf_Grp = JDomExtUtils.addChild((Element)request, (String)"BsnInf_Grp");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"CstPty_TxnSrlNo", (String)paymentInfo.getBankDetailSeqId());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Hdl_InsID", (String)BankBusinessConfig.getJBJGBHFromAcntNo((String)paymentInfo.getAccNo()));
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"APPROVE_TYPE_CD", (String)"02");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Aply_Chnl_TpCd", (String)"0025");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Pyr_Cst_AccNo", (String)paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Pyr_AccNm", (String)paymentInfo.getAccName());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Pyr_Adr", (String)bankPayRequest.getAcnt().getBankAddress().replace(",", ""));
        String xxhtbh = BankBusinessConfig.getXXHTBHFromAcntNo((String)paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Cptd_Bsn_Ctr_ID", (String)xxhtbh);
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Rqs_Amt", (String)paymentInfo.getAmount().toString());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"TnCcy_Cd", (String)paymentInfo.getCurrency());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"PAY_TYPE_CD", (String)(StringUtils.isEmpty((String)xxhtbh) ? "2" : "1"));
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"PymDt", (String)date);
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RcvPrt_BkCgyCd", (String)(paymentInfo.is2SameBank() ? "01" : "02"));
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RcvPrt_Cst_AccNo", (String)paymentInfo.getIncomeAccNo());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RcvPrt_DpBkNm", (String)paymentInfo.getIncomeBankName());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RcvPrt_Adr", (String)paymentInfo.getIncomeBankAddress());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Use_Nm", (String)paymentInfo.getExplanation());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"CstPty_Py_Jrnl_No", (String)paymentInfo.getBankDetailSeqId());
        if (paymentInfo.is2SameBank()) {
            SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
            String bankNo = settBankKeyWordsRepository.matchBankNoByKey(paymentInfo.getIncomeBankName());
            if (StringUtils.isEmpty((String)bankNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u6e05\u7b97\u884c\u53f7\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u5f55\u5165\u5bf9\u5e94\u6e05\u7b97\u884c\u4fe1\u606f\u3002", (String)"CZPaymentImpl_1", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]));
            }
            JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RcvPrt_DepBnk_No", (String)bankNo);
        } else {
            JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RcvPrt_BnkCD", (String)paymentInfo.getIncomeCnaps());
        }
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RcvPtAc_Nm", (String)paymentInfo.getIncomeAccName());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"ASPD_ECD", (String)"O0120002");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"SChl_No", (String)"000000000000000");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"FwCtl_Node_ID", (String)"000000000000000");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Cst_ID", (String)RequestContextUtils.getBankParameterValue((String)"cstid"));
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Cst_Nm", (String)paymentInfo.getAccName());
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"PdAr_ID", (String)BankBusinessConfig.getCPHYHFromAccNo((String)paymentInfo.getAccNo()));
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"SvM24Hr_Ind", (String)"0");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Tmzon_ECD", (String)"08");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"CCstTr_ID", (String)RequestContextUtils.getBankParameterValue((String)"ccsttrid"));
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"CCstTrNdID", (String)RequestContextUtils.getBankParameterValue((String)"ccsttrnddid"));
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RvPy_Txn_TpCd", (String)"15");
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Cst_Dlv_Dt", (String)date);
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"Cst_Dlv_Dt", (String)date);
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"Cst_Dlv_Tm", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("hhmmssSSS")));
        JDomExtUtils.addChildCDData((Element)BsnInf_Grp, (String)"RvPy_ExMd_Cd", (String)"0");
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        return new PaymentImpl().parse(bankPayRequest, rspStr);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1G015011";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d22\u8d44\u6237\u652f\u4ed8\u8f6c\u8d26\u3002", (String)"CZPaymentImpl_0", (String)"ebg-aqap-banks-cdb-ccip", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String accNo = paymentInfo.getAccNo();
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.isJGAcc((String)accNo) != false;
    }
}

