/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.curandfixed.fixed2notice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class CurAndFixedImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedImpl.class);

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String bizCode = "SDKNTSMAOPR";
        JSONObject head = JsonUtil.getHead((String)bizCode, (String)Sequence.genSequence());
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        logger.info("----------------------xxxxxxxxx------------>" + acnt.getAreaCode());
        JSONObject ntsmaoprx = new JSONObject();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        String busmod = BankBusinessConfig.getCurAndNotiiBusMod(acnt.getAccNo());
        ntsmaoprx.put("buscod", (Object)"N08020");
        ntsmaoprx.put("busmod", (Object)busmod);
        String areaCode = AreaCodeImpl.getInstance().getAreaCode(acnt);
        ntsmaoprx.put("bbknbr", (Object)areaCode);
        ntsmaoprx.put("accnbr", (Object)curAndFixedInfo.getAccNo());
        ntsmaoprx.put("ccynbr", (Object)curAndFixedInfo.getCurrency());
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal add = amount.add(new BigDecimal(curAndFixedInfo.getAmount()));
        if (add.compareTo(new BigDecimal("500000")) < 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"<Check>\u5f00\u7acb\u901a\u77e5\u8d26\u6237\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e500000</Check>\u3002", (String)"CurAndFixedImpl_7", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        ntsmaoprx.put("trsamt", (Object)curAndFixedInfo.getAmount());
        ntsmaoprx.put("inftyp", (Object)curAndFixedInfo.getInftyp());
        ntsmaoprx.put("yurref", (Object)PaymentUtil.addKDFlag(bankCurAndFixedRequest.getBatchSeqId()));
        JSONArray array = new JSONArray();
        array.add((Object)ntsmaoprx);
        JSONObject body = new JSONObject();
        body.put("ntsmaoprx", (Object)array);
        JSONObject request = JsonUtil.getrequest((JSONObject)head, (JSONObject)body);
        logger.info("\u5373\u5c06\u53d1\u9001\u7684\u62a5\u6587>>>>>>>>>>>>>>>>>>>{}", (Object)request.toJSONString());
        if (EBContext.getContext().isUnitTest()) {
            return "";
        }
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankCurAndFixedResponse doBiz(BankCurAndFixedRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        String res = MsgParser.getReceMsg(s, logger);
        return this.parse(res, bankCurAndFixedRequest);
    }

    public EBBankCurAndFixedResponse parse(String res, BankCurAndFixedRequest bankCurAndFixedRequest) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"CurAndFixedImpl_11", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntsmaoprz = body.getJSONArray("ntsmaoprz");
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        if (ntsmaoprz.size() <= 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\u3002", (String)"CurAndFixedImpl_8", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        JSONObject detail = ntsmaoprz.getJSONObject(0);
        String bbknbr = detail.getString("bbknbr");
        String accnbr = detail.getString("accnbr");
        String reqnbr = detail.getString("reqnbr");
        curAndFixedInfo.setAcntBankNo(bbknbr);
        curAndFixedInfo.setFixedAccNo(accnbr);
        curAndFixedInfo.setReqNbr(reqnbr);
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public int getBatchSize() {
        return 0;
    }
}

