/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.curandfixed.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.service.curandfixed.CurAndFixedAdapter;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.currentandfixed.QueryCurAndFixedBizType;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class RequestForReqnbr {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RequestForReqnbr.class);
    private static RequestForReqnbr instance = null;

    public static RequestForReqnbr getInstance() {
        if (instance == null) {
            return new RequestForReqnbr();
        }
        return instance;
    }

    public boolean setReqnbr(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String str = this.pack(bankCurAndFixedRequest);
        String s = PostUtil.sendMsg(str);
        return this.parse(bankCurAndFixedRequest, s);
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String bizCode = "QueryFixNotify";
        JSONObject head = JsonUtil.getHead((String)bizCode, (String)Sequence.genSequence());
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        JSONObject ntqryfncy = new JSONObject();
        String buscod = "****";
        String oprtyp = "***";
        String code = QueryCurAndFixedBizType.findCodeByName((String)bankCurAndFixedRequest.getHeader().getSubBizType()).getCode();
        String implClassName = curAndFixedInfo.getImplClassName();
        CurAndFixedAdapter adapter = new CurAndFixedAdapter();
        if ("0".equalsIgnoreCase(code)) {
            buscod = "N08010";
            oprtyp = "CTF";
        } else if ("1".equalsIgnoreCase(code)) {
            buscod = "N08010";
            oprtyp = "FTC";
        } else if ("2".equalsIgnoreCase(code)) {
            buscod = "N08020";
            oprtyp = "CTS";
        } else if (adapter.getWithDrawNoticeBalImplClassName().equalsIgnoreCase(implClassName)) {
            buscod = "N08020";
            oprtyp = "STC";
        } else {
            buscod = "N08020";
            oprtyp = "NTF";
        }
        ntqryfncy.put("buscod", (Object)buscod);
        ntqryfncy.put("oprtyp", (Object)oprtyp);
        Date date = Date.from(curAndFixedInfo.getTranDate().toLocalDate().atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        ntqryfncy.put("bgndat", (Object)DateUtil.formatDate((Date)date));
        ntqryfncy.put("enddat", (Object)DateUtil.formatDate((Date)date));
        if ("0".equalsIgnoreCase(code) || "2".equalsIgnoreCase(code)) {
            ntqryfncy.put("accnbr", (Object)curAndFixedInfo.getAccNo());
        } else {
            ntqryfncy.put("fixacc", (Object)curAndFixedInfo.getFixedAccNo());
        }
        ntqryfncy.put("yurref", (Object)PaymentUtil.addKDFlag(curAndFixedInfo.getBatchSeqId()));
        JSONArray array = new JSONArray();
        array.add((Object)ntqryfncy);
        JSONObject body = new JSONObject();
        body.put("ntqryfncy", (Object)array);
        JSONObject request = JsonUtil.getrequest((JSONObject)head, (JSONObject)body);
        logger.info("\u5373\u5c06\u53d1\u9001\u7684\u62a5\u6587>>>>>>>>>>>>>>>>>>>", (Object)request.toJSONString());
        if (EBContext.getContext().isUnitTest()) {
            return "";
        }
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public boolean parse(BankCurAndFixedRequest bankCurAndFixedRequest, String str) {
        String receMsg = MsgParser.getReceMsg(str, logger);
        return this.parse(receMsg, bankCurAndFixedRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parse(String receMsg, BankCurAndFixedRequest bankCurAndFixedRequest) {
        List details = bankCurAndFixedRequest.getCafInfos();
        BankResponse response = MsgParser.getResponse(receMsg, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"RequestForReqnbr_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)receMsg);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntqryfncz = body.getJSONArray("ntqryfncz");
        if (ntqryfncz != null && !ntqryfncz.isEmpty()) {
            CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)details.get(0);
            JSONObject detail = ntqryfncz.getJSONObject(0);
            String reqsta = detail.getString("reqsta");
            String rtnflg = detail.getString("rtnflg");
            String c_reqsta = detail.getString("c_reqsta");
            if (StringUtils.isEmpty((String)reqsta) || StringUtils.isEmpty((String)rtnflg)) {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"RequestForReqnbr_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)"", (String)c_reqsta);
            } else {
                if ("FIN".equalsIgnoreCase(reqsta) && "S".equalsIgnoreCase(rtnflg)) {
                    String reqnbr = detail.getString("reqnbr");
                    logger.info("\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u4e3a\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>{}", (Object)reqnbr);
                    curAndFixedInfo.setReqNbr(reqnbr);
                    return true;
                }
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"RequestForReqnbr_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnflg, (String)c_reqsta);
            }
        } else {
            logger.info("\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\u3002", (String)"RequestForReqnbr_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        bankCurAndFixedRequest.setCafInfos(details);
        return false;
    }
}

