/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.financing.buy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.service.payment.BusModUtil;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IBuyFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BuyFinancingImpl
extends AbstractFinancingImpl
implements IBuyFinancing {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BuyFinancingImpl.class);

    public EBBankFinancingResponse doBiz(BankFinancingRequest request) {
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(request, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NTQDBOPR";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d2d\u4e70\u7406\u8d22", (String)"BuyFinancingImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return true;
    }

    public String pack(BankFinancingRequest bankFinancingRequest) {
        List infos = bankFinancingRequest.getInfos();
        if (infos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62db\u884c\u7406\u8d22\u4ea7\u54c1\u8d2d\u4e70\u7ecf\u529e\u4ec5\u652f\u6301\u5355\u7b14\u4ea4\u6613\u3002", (String)"BuyFinancingImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONObject body = new JSONObject();
        JSONObject ntqdboprx = new JSONObject();
        FinancingInfo info = (FinancingInfo)infos.get(0);
        String accno = info.getAccNo();
        String busMod = BankBusinessConfig.getNtqdboprBusmod(accno);
        if (StringUtils.isEmpty((String)busMod)) {
            this.logger.info("\u94f6\u4f01\u672a\u7ef4\u62a4\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\uff0c\u4ece\u94f6\u884c\u83b7\u53d6");
            busMod = BusModUtil.getBusMod((String)"N24010");
            String busModName = ResManager.loadKDString((String)"\u7406\u8d22\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7", (String)"BuyFinancingImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
            if (StringUtils.isEmpty((String)busMod)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%s\u4e3a\u7a7a\uff0c\u8bf7\u767b\u9646\u7f51\u94f6\u6216\u8005\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"BuyFinancingImpl_9", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), busModName));
            }
            if (busMod.contains(",")) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%1$s\u6709\u591a\u4e2a%2$s\uff0c\u8bf7\u4e8e\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u4e2d\u624b\u52a8\u914d\u7f6e\u552f\u4e00\u7684\u2018%3$s\u2019\u3002", (String)"BuyFinancingImpl_10", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), busModName, busMod, busModName));
            }
            ObjectPropertyService objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
            objectPropertyService.saveAcntProperties("ntqdbopr_busmod", busMod, accno);
        }
        ntqdboprx.put("busmod", (Object)busMod);
        ntqdboprx.put("modals", (Object)"");
        ntqdboprx.put("bbknbr", (Object)AreaCodeImpl.getInstance().getAreaCode(bankFinancingRequest.getAcnt()));
        ntqdboprx.put("eacnbr", (Object)accno);
        ntqdboprx.put("ripcod", (Object)info.getProductCode());
        ntqdboprx.put("ordqty", (Object)info.getAmount());
        ntqdboprx.put("ccymkt", (Object)"N");
        ntqdboprx.put("yurref", (Object)PaymentUtil.addKDFlag(info.getBankFinancingSeqId()));
        body.put("ntqdboprx", (Object)ntqdboprx);
        String bizCode = this.getBizCode();
        JSONObject head = JsonUtil.getHead((String)bizCode, (String)Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest((JSONObject)head, (JSONObject)body);
        return MsgPacker.getSendMsg(request, this.logger, bizCode);
    }

    public EBBankFinancingResponse parse(BankFinancingRequest bankFinancingRequest, String s) {
        String respStr = MsgParser.getReceMsg(s, this.logger);
        return this.parse(respStr, bankFinancingRequest);
    }

    public EBBankFinancingResponse parse(String respStr, BankFinancingRequest bankFinancingRequest) {
        EBBankFinancingResponse result = new EBBankFinancingResponse();
        BankResponse response = MsgParser.getResponse(respStr, this.logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"BuyFinancingImpl_11", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)respStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray array = body.getJSONArray("ntoprrstz");
        List infos = bankFinancingRequest.getInfos();
        if (array.size() > 0) {
            FinancingInfo info = (FinancingInfo)infos.get(0);
            JSONObject detail = array.getJSONObject(0);
            String reqsts = detail.getString("reqsts");
            String rtnflg = detail.getString("rtnflg");
            if ("BAC".equalsIgnoreCase(reqsts) || "FIN".equalsIgnoreCase(reqsts)) {
                FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BuyFinancingImpl_7", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)reqsts, (String)"");
            } else {
                FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.UNKNOWN, (String)"", (String)reqsts, (String)"");
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u4e2d\u94f6\u884c\u8fd4\u56de\u4e86\u7a7a\u6570\u636e\u3002", (String)"BuyFinancingImpl_8", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        result.setInfos(infos);
        return result;
    }
}

