/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.company;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.service.payment.company.BB1FAMCKUtil;
import kd.ebg.aqap.banks.cmb.opa.service.payment.company.BB1REMQYUtil;
import kd.ebg.aqap.banks.cmb.opa.service.payment.company.CompanyPaymentQueryImpl;
import kd.ebg.aqap.banks.cmb.opa.service.payment.company.PayPacker;
import kd.ebg.aqap.banks.cmb.opa.service.payment.company.PayParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class CompanyPaymentImpl
extends AbstractPayImpl
implements IPay {
    private PayPacker payPacker = new PayPacker();
    private PayParser payParser = new PayParser();

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u738b\u6dbf", (String)"CompanyPaymentImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "BB1PAYOP";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u5916\u5bf9\u516c\u652f\u4ed8", (String)"CompanyPaymentImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String rsqt;
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        try {
            String result;
            String flag = PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[0], (String)"cmbForeignUser");
            boolean isNeedReport = false;
            if ("true".equals(flag) && "Y".equals(result = new BB1FAMCKUtil().dobussiness(paymentInfos[0]))) {
                isNeedReport = true;
            }
            if (isNeedReport) {
                paymentInfos[0] = new BB1REMQYUtil().dobussiness(paymentInfos[0]);
            }
            rsqt = this.pack(request);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bf7\u6c42\u8fde\u63a5\u94f6\u884c\u524d\u5f02\u5e38:%s\u3002", (String)"CompanyPaymentImpl_10", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ex.getMessage()), (Throwable)ex);
        }
        EBBankPayResponse response = null;
        try {
            String rspStr = PostUtil.sendMsgForPay(rsqt);
            response = this.parse(request, rspStr);
            return response;
        }
        catch (Throwable t) {
            EBContext.getContext().setThrowableAfterSend(t);
            EBExceiptionUtil.serviceException((Throwable)t);
            return response;
        }
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String rsqt = this.payPacker.packPay(paymentInfos);
        return rsqt;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyPaymentQueryImpl.class;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        this.payParser.parsePay(bankPayRequest.getPaymentInfoAsArray(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

