/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.company;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.service.payment.company.QueryPayPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.business.detail.item.TransTypeEnum;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryPayParser {
    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayPacker.class);
        String res = MsgParser.getReceMsg(rspStr, logger);
        this.parseQueryPay(paymentInfos, res, logger);
    }

    public void parseQueryPay(PaymentInfo[] paymentInfos, String res, EBGLogger logger) throws EBServiceException {
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38%s\u3002", (String)"QueryPayParser_13", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray array = body.getJSONArray("bb1payqrz1");
        if (array != null && array.size() > 0) {
            JSONObject bb1payopz1 = array.getJSONObject(0);
            String reqSts = bb1payopz1.getString("reqSts");
            String rtnFlg = bb1payopz1.getString("rtnFlg");
            String rtnNar = bb1payopz1.getString("rtnNar");
            if ("FIN".equals(reqSts)) {
                if ("F".equals(rtnFlg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                } else if ("R".equals(rtnFlg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u5ba1\u6279\u5426\u51b3", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                } else if ("C".equals(rtnFlg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u64a4\u9500", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                } else if ("D".equals(rtnFlg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u8fc7\u671f\u4e0d\u5ba1\u6279", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                } else if ("S".equals(rtnFlg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                } else if ("B".equals(rtnFlg)) {
                    this.setRefundNo(paymentInfos);
                    this.parsePayStatusForRefund(paymentInfos, rtnFlg, rtnNar);
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryPayParser_9", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryPayParser_9", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }

    public void parsePayStatusForRefund(PaymentInfo[] paymentInfos, String rtnFlg, String rtnNar) {
        PaymentState paymentState = BankBusinessConfig.isPaySuccessForRefund() ? PaymentState.SUCCESS : PaymentState.FAIL;
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)paymentState, (String)ResManager.loadKDString((String)"\u9000\u7968", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
    }

    private void setRefundNo(PaymentInfo[] paymentInfos) {
        String refundNo = PaymentUtil.getYurRef(paymentInfos[0]);
        for (PaymentInfo paymentInfo : paymentInfos) {
            paymentInfo.setBiz(TransTypeEnum.REFUND.getName(), refundNo);
        }
    }
}

