/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.oversea.upload;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.CleanPathUtil;

public class DCHelper {
    private static final String BOUNDARY_PREFIX = "--";
    private static final String LINE_END = "\r\n";
    private static final String UPLOAD_URI = "/cdcserver/upload";
    static EBGLogger logger = EBGLogger.getInstance().getLogger(DCHelper.class);

    public static String sendFileMsg(String encryptData, List<String> filePaths, String funcode) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filePaths.size(); ++i) {
            sb.append(filePaths.get(i));
            if (i == filePaths.size() - 1) continue;
            sb.append(';');
        }
        return DCHelper.sendFileMsg(encryptData, sb.toString(), funcode);
    }

    public static String sendFileMsg(String encryptData, String filePath, String funcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String loginName = RequestContextUtils.getBankParameterValue((String)"lgnnam");
        map.put("UID", loginName);
        if (BankBusinessConfig.isSaasCloud()) {
            map.put("INSPLAT", "KINGDEE");
        }
        map.put("ALG", "SM");
        map.put("FUNCODE", funcode);
        HashMap<String, String> filePathMap = new HashMap<String, String>(1);
        String paramName = "multipartFile";
        filePathMap.put(paramName, filePath);
        String url = DCHelper.getUploadUrl();
        logger.info("\u9644\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u5730\u5740\uff1a" + url);
        try {
            map.put("DATA", encryptData);
            String res = DCHelper.doPostFileUp(url, map, filePathMap);
            return res;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u4e92\u5931\u8d25\u3002", (String)"PostUtil_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static String getUploadUrl() {
        String exchangeProtocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        String host = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        port = "HTTPS".equalsIgnoreCase(exchangeProtocol) && "443".equalsIgnoreCase(port) ? "" : ":" + port;
        StringBuilder sb = new StringBuilder();
        sb.append(exchangeProtocol.toLowerCase(Locale.ENGLISH)).append("://").append(host).append(port).append(UPLOAD_URI);
        return sb.toString();
    }

    public static String getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }

    public static HttpURLConnection getHttpConnection(String httpUrl, String boundary) throws NoSuchAlgorithmException, IOException, KeyManagementException, KeyStoreException {
        HttpURLConnection connection = null;
        URL url = new URL(httpUrl);
        SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager defaultTm = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            defaultTm = (X509TrustManager)tm;
            break;
        }
        sslcontext.init(null, new TrustManager[]{defaultTm}, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(60000);
        connection.setInstanceFollowRedirects(true);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        return connection;
    }

    public static void writeParamValue(DataOutputStream out, String boundary, Map<String, Object> paramValues) throws IOException {
        if (paramValues != null && !paramValues.isEmpty()) {
            for (Map.Entry<String, Object> entry : paramValues.entrySet()) {
                DCHelper.writeSimpleFormField(boundary, out, entry);
            }
        }
    }

    public static void writeFileAttachment(DataOutputStream out, String boundary, Map<String, String> filePathMap) throws IOException {
        if (filePathMap != null && !filePathMap.isEmpty()) {
            for (Map.Entry<String, String> filePath : filePathMap.entrySet()) {
                if ("multipartFile".equals(filePath.getKey())) {
                    if (filePath.getValue().contains(";")) {
                        String[] filePaths;
                        for (String realPath : filePaths = filePath.getValue().split(";")) {
                            DCHelper.writeFile(filePath.getKey(), realPath, boundary, out);
                        }
                        continue;
                    }
                    DCHelper.writeFile(filePath.getKey(), filePath.getValue(), boundary, out);
                    continue;
                }
                DCHelper.writeFile(filePath.getKey(), filePath.getValue(), boundary, out);
            }
        }
    }

    public static void writeLine(DataOutputStream out, String boundary) throws IOException {
        String endStr = BOUNDARY_PREFIX + boundary + BOUNDARY_PREFIX + LINE_END;
        out.write(endStr.getBytes());
        out.flush();
    }

    public static String parseHttpResponse(HttpURLConnection connection) throws IOException {
        boolean isFail = connection.getResponseCode() != 200;
        try (InputStream is = isFail ? connection.getErrorStream() : connection.getInputStream();){
            StringBuilder sbf = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                String temp;
                if (isFail) {
                    while ((temp = br.readLine()) != null) {
                        sbf.append(temp);
                        sbf.append(LINE_END);
                    }
                } else {
                    boolean firstLine = true;
                    while ((temp = br.readLine()) != null) {
                        if (!firstLine) {
                            firstLine = false;
                            sbf.append(LINE_END);
                        }
                        sbf.append(temp);
                    }
                }
            }
            String string = sbf.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostFileUp(String httpUrl, Map<String, Object> paramValues, Map<String, String> filePathMap) throws Exception {
        String string;
        HttpURLConnection connection = null;
        try {
            String boundary = "CDCBoundary" + System.currentTimeMillis();
            connection = DCHelper.getHttpConnection(httpUrl, boundary);
            try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
                DCHelper.writeParamValue(out, boundary, paramValues);
                DCHelper.writeFileAttachment(out, boundary, filePathMap);
                DCHelper.writeLine(out, boundary);
            }
            string = DCHelper.parseHttpResponse(connection);
        }
        catch (Throwable throwable) {
            DCHelper.safeClose(connection);
            throw throwable;
        }
        DCHelper.safeClose(connection);
        return string;
    }

    public static void safeClose(HttpURLConnection connection) {
        if (connection != null) {
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                logger.error("IOException", (Throwable)e);
            }
        }
    }

    public static void writeSimpleFormField(String boundary, DataOutputStream out, Map.Entry<String, Object> entry) throws IOException {
        String boundaryStr = BOUNDARY_PREFIX + boundary + LINE_END;
        out.write(boundaryStr.getBytes());
        String contentDispositionStr = String.format("Content-Disposition: form-data; name=\"%s\"", entry.getKey()) + LINE_END + LINE_END;
        out.write(contentDispositionStr.getBytes());
        String valueStr = entry.getValue().toString() + LINE_END;
        out.write(valueStr.getBytes());
    }

    public static void writeFile(String paramName, String filePath, String boundary, DataOutputStream out) throws IOException {
        String boundaryStr = BOUNDARY_PREFIX + boundary + LINE_END;
        out.write(boundaryStr.getBytes());
        File file = new File(CleanPathUtil.cleanString((String)filePath));
        String fileName = file.getName();
        String contentDispositionStr = String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", paramName, fileName) + LINE_END;
        out.write(contentDispositionStr.getBytes());
        String contentType = "Content-Type: application/octet-stream\r\n\r\n";
        out.write(contentType.getBytes());
        try (FileInputStream fis = new FileInputStream(file);){
            int readLen;
            byte[] buffer = new byte[1024];
            while ((readLen = fis.read(buffer)) != -1) {
                out.write(buffer, 0, readLen);
            }
            out.write(LINE_END.getBytes());
        }
    }
}

