/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.util;

import java.security.Provider;
import java.security.Security;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.Base64;
import kd.ebg.aqap.banks.cmb.opa.util.DCCryptor;
import kd.ebg.aqap.banks.cmb.opa.util.GetStore;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SMUtil {
    private static String getAES_KEY_NULL_MSG() {
        return ResManager.loadKDString((String)"\u5bf9\u79f0\u5bc6\u94a5\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SMUtil_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    private static String getPLAT_KEY_NULL_MSG() {
        return ResManager.loadKDString((String)"\u5e73\u53f0\u5bc6\u94a5\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SMUtil_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    private static String getUSER_KEY_NULL_MSG() {
        return ResManager.loadKDString((String)"\u7528\u6237\u79c1\u94a5\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SMUtil_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public static String signUser(String content) {
        try {
            String privkey = GetStore.getRSA();
            if (StringUtils.isEmpty((String)privkey)) {
                throw EBExceiptionUtil.serviceException((String)SMUtil.getUSER_KEY_NULL_MSG());
            }
            byte[] signature1 = DCCryptor.CMBSM2SignWithSM3((byte[])SMUtil.getID_IV(), (byte[])Base64.decode((String)privkey), (byte[])content.getBytes("UTF-8"));
            String sigdat1 = Base64.encode((byte[])signature1);
            return sigdat1;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String signKingdee(String content) {
        try {
            String privkey = GetStore.getPlateFormRSA();
            if (StringUtils.isEmpty((String)privkey)) {
                throw EBExceiptionUtil.serviceException((String)SMUtil.getPLAT_KEY_NULL_MSG());
            }
            byte[] signature1 = DCCryptor.CMBSM2SignWithSM3((byte[])SMUtil.getID_IV(), (byte[])Base64.decode((String)privkey), (byte[])content.getBytes("UTF-8"));
            String sigdat1 = Base64.encode((byte[])signature1);
            return sigdat1;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String encrypt(String content) {
        try {
            String key = GetStore.getAES();
            if (StringUtils.isEmpty((String)key)) {
                throw EBExceiptionUtil.serviceException((String)SMUtil.getAES_KEY_NULL_MSG());
            }
            byte[] enInput = DCCryptor.CMBSM4EncryptWithCBC((byte[])key.getBytes(), (byte[])SMUtil.getID_IV(), (byte[])content.getBytes("UTF-8"));
            String req = Base64.encode((byte[])enInput);
            return req;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String deCipher(String content) {
        String key = GetStore.getAES();
        if (StringUtils.isEmpty((String)key)) {
            throw EBExceiptionUtil.serviceException((String)SMUtil.getAES_KEY_NULL_MSG());
        }
        String enInput = StringUtils.byteToString((byte[])DCCryptor.CMBSM4DecryptWithCBC((byte[])key.getBytes(), (byte[])SMUtil.getID_IV(), (byte[])Base64.decode((String)content)), (String)"UTF-8");
        return enInput;
    }

    private static byte[] getID_IV() throws EBServiceException {
        String uid = RequestContextUtils.getBankParameterValue((String)"lgnnam");
        String userid = uid + "0000000000000000";
        return userid.substring(0, 16).getBytes();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

